/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.helpers;

import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import java.util.HashMap;
import java.util.Objects;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.springframework.util.StringUtils;

public final class RedactHelper {
    private RedactHelper() {
    }

    static Command redactCommand(ReportingCommandsExecutor executor, Command command) {
        if (command.getName().equals("sendKeysToElement") || command.getName().equals("sendKeysToActiveElement")) {
            String elementId = command.getParameters().get("id").toString();
            if (!RedactHelper.isRedactRequired(executor, command, elementId)) {
                return command;
            }
            HashMap<String, String> clonedParameters = new HashMap<String, String>();
            command.getParameters().forEach(clonedParameters::put);
            clonedParameters.put("value", "***");
            return new Command(command.getSessionId(), command.getName(), clonedParameters);
        }
        return command;
    }

    private static boolean isRedactRequired(ReportingCommandsExecutor executor, Command command, String elementId) {
        Capabilities capabilities = executor.getAgentClient().getSession().getCapabilities();
        String platformName = capabilities.getCapability("platformName").toString();
        if (platformName.equalsIgnoreCase(Platform.ANDROID.name()) && StringUtils.isEmpty((Object)capabilities.getCapability("browserName"))) {
            return RedactHelper.isAndroidPasswordElement(executor, command.getSessionId(), elementId);
        }
        return RedactHelper.isSecuredElement(executor, command.getSessionId(), elementId);
    }

    private static boolean isAndroidPasswordElement(ReportingCommandsExecutor executor, SessionId sessionId, String elementId) {
        HashMap<String, String> getAttributeParams = new HashMap<String, String>();
        getAttributeParams.put("id", elementId);
        getAttributeParams.put("name", "password");
        Response response = executor.execute(new Command(sessionId, "getElementAttribute", getAttributeParams), true);
        return response.getStatus() == 0 && Boolean.parseBoolean(Objects.requireNonNullElse(response.getValue(), "").toString());
    }

    private static boolean isSecuredElement(ReportingCommandsExecutor executor, SessionId sessionId, String elementId) {
        HashMap<String, String> getAttributeParams = new HashMap<String, String>();
        getAttributeParams.put("id", elementId);
        getAttributeParams.put("name", "type");
        Response response = executor.execute(new Command(sessionId, "getElementAttribute", getAttributeParams), true);
        String inputType = response.getStatus() == 0 ? Objects.requireNonNullElse(response.getValue(), "").toString() : "";
        return inputType.equals("password") || inputType.equals("XCUIElementTypeSecureTextField");
    }
}

