/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting;

import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.reporting.ClosableTestReport;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.messages.StepReport;
import java.util.Arrays;
import java.util.List;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Reporter {
    private static final Logger LOG = LoggerFactory.getLogger(Reporter.class);
    private final AgentClient agentClient;
    private final ReportingDriver driver;

    public Reporter(ReportingDriver driver, AgentClient agentClient) {
        this.agentClient = agentClient;
        this.driver = driver;
    }

    public void disableReports(boolean disable) {
        this.driver.getReportingCommandExecutor().setReportsDisabled(disable);
    }

    public void disableCommandReports(boolean disable) {
        this.driver.getReportingCommandExecutor().setCommandReportsDisabled(disable);
    }

    public void disableTestAutoReports(boolean disable) {
        this.driver.getReportingCommandExecutor().setTestAutoReportsDisabled(disable);
    }

    public void disableRedaction(boolean disable) {
        this.driver.getReportingCommandExecutor().setRedactionDisabled(disable);
    }

    public void step(String description) {
        this.step(description, "", false);
    }

    public void step(String description, boolean passed) {
        this.step(description, passed, false);
    }

    public void step(String description, boolean passed, boolean screenshot) {
        this.step(description, "", passed, screenshot);
    }

    public void step(String description, String message) {
        this.step(description, message, true, false);
    }

    public void step(String description, String message, boolean screenshot) {
        this.step(description, message, true, screenshot);
    }

    public void step(String description, String message, boolean passed, boolean screenshot) {
        if (!this.driver.getReportingCommandExecutor().isReportsDisabled()) {
            List<StackTraceElement> traces = Arrays.asList(Thread.currentThread().getStackTrace());
            this.driver.getReportingCommandExecutor().reportTest(traces, false);
        }
        StepReport report = new StepReport(description, message, passed, screenshot ? this.driver.getScreenshot() : null);
        if (this.driver.getReportingCommandExecutor().isReportsDisabled()) {
            LOG.trace("Step [{}] - [{}]", (Object)description, (Object)(passed ? "Passed" : "Failed"));
            return;
        }
        if (!this.agentClient.reportStep(report)) {
            LOG.error("Failed reporting step to Agent");
        }
    }

    public ClosableTestReport test(String name) {
        return this.test(name, false);
    }

    public ClosableTestReport test(String name, boolean passed) {
        return this.test(name, passed, null);
    }

    public ClosableTestReport test(String name, boolean passed, String message) {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)((RemoteWebDriver)this.driver).getCommandExecutor();
        if (!executor.isTestAutoReportsDisabled()) {
            LOG.warn("Automatic test reports is enabled, disable it to report tests manually and avoid duplicates.");
        }
        return new ClosableTestReport(this.agentClient, this.driver, name, passed, message);
    }
}

