/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers;

import io.testproject.sdk.drivers.GenericDriver;
import io.testproject.sdk.internal.addons.AddonsHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.reporting.Reporter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ReportingDriver {
    public static final Logger LOG = LoggerFactory.getLogger(ReportingDriver.class);

    public Reporter report();

    default public String getScreenshot() {
        if (this instanceof GenericDriver) {
            LOG.warn("Taking screenshots is not possible with Generic Driver");
            return null;
        }
        RemoteWebDriver rwd = (RemoteWebDriver)this;
        Command command = new Command(rwd.getSessionId(), "screenshot");
        Response response = this.getReportingCommandExecutor().execute(command, true);
        return response.getValue().toString();
    }

    default public ReportingCommandsExecutor getReportingCommandExecutor() {
        RemoteWebDriver rwd = (RemoteWebDriver)this;
        return (ReportingCommandsExecutor)rwd.getCommandExecutor();
    }

    public void stop();

    default public AddonsHelper addons() {
        return new AddonsHelper(this.getReportingCommandExecutor().getAgentClient());
    }
}

