/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.helpers;

import io.appium.java_client.MobileCommand;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.helpers.StashedCommands;
import io.testproject.sdk.internal.rest.AgentClient;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.http.W3CHttpCommandCodec;

public final class CustomAppiumCommandExecutor
extends AppiumCommandExecutor
implements ReportingCommandsExecutor {
    private final AgentClient agentClient;
    private final StashedCommands stashedCommands = new StashedCommands();
    private boolean reportsDisabled;
    private boolean commandReportsDisabled;
    private boolean testReportsDisabled;
    private boolean redactionDisabled;
    private final AtomicReference<String> currentTest = new AtomicReference<Object>(null);

    public CustomAppiumCommandExecutor(AgentClient agentClient, URL addressOfRemoteServer) {
        super(MobileCommand.commandRepository, addressOfRemoteServer);
        this.agentClient = agentClient;
        CommandCodec commandCodec = agentClient.getSession().getDialect().getCommandCodec();
        if (commandCodec instanceof W3CHttpCommandCodec) {
            commandCodec = new AppiumW3CHttpCommandCodec();
        }
        DriverHelper.setPrivateFieldValue(this, "commandCodec", commandCodec);
        DriverHelper.setPrivateFieldValue(this, "responseCodec", agentClient.getSession().getDialect().getResponseCodec());
        this.getAdditionalCommands().forEach((arg_0, arg_1) -> ((CustomAppiumCommandExecutor)this).defineCommand(arg_0, arg_1));
    }

    public Response execute(Command command) throws WebDriverException {
        return this.execute(command, false);
    }

    @Override
    public Response execute(Command command, boolean skipReporting) {
        Response response = null;
        if (!command.getName().equals("quit")) {
            response = super.execute(command);
        }
        if (!skipReporting) {
            this.reportCommand(command, response);
        }
        return response;
    }

    @Override
    public AgentClient getAgentClient() {
        return this.agentClient;
    }

    @Override
    public StashedCommands getStashedCommands() {
        return this.stashedCommands;
    }

    @Override
    public boolean isReportsDisabled() {
        return this.reportsDisabled;
    }

    @Override
    public void setReportsDisabled(boolean disable) {
        this.reportsDisabled = disable;
    }

    @Override
    public boolean isCommandReportsDisabled() {
        return this.commandReportsDisabled;
    }

    @Override
    public void setCommandReportsDisabled(boolean disable) {
        this.commandReportsDisabled = disable;
    }

    @Override
    public boolean isTestAutoReportsDisabled() {
        return this.testReportsDisabled;
    }

    @Override
    public void setTestAutoReportsDisabled(boolean disable) {
        this.testReportsDisabled = disable;
    }

    @Override
    public boolean isRedactionDisabled() {
        return this.redactionDisabled;
    }

    @Override
    public void setRedactionDisabled(boolean disable) {
        this.redactionDisabled = disable;
    }

    @Override
    public AtomicReference<String> getCurrentTest() {
        return this.currentTest;
    }
}

