/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.inferrers;

import io.testproject.sdk.internal.reporting.inferrers.ReportSettingsInferrer;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNGInferrer
implements ReportSettingsInferrer {
    private static final Logger LOG = LoggerFactory.getLogger(TestNGInferrer.class);
    private final List<StackTraceElement> traces;

    public TestNGInferrer(List<StackTraceElement> traces) {
        this.traces = traces;
    }

    @Override
    public ReportSettings inferReportSettings() {
        for (StackTraceElement stackTraceElement : this.traces) {
            Class<?> clazz;
            try {
                clazz = Class.forName(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to create an instance of a class", (Throwable)e);
                return this.getUnnamedEntries();
            }
            Optional<Method> method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(stackTraceElement.getMethodName())).findFirst();
            if (method.isEmpty() || !Arrays.stream(method.get().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().startsWith("org.testng"))) continue;
            ReportSettings result = this.inspectAnnotations(clazz);
            return Objects.requireNonNullElseGet(result, () -> new ReportSettings(this.getPackageName(clazz), clazz.getSimpleName()));
        }
        LOG.warn("Something is wrong... TestNG classes in stack but no annotated methods were found.");
        return this.getUnnamedEntries();
    }

    private ReportSettings inspectAnnotations(Class<?> clazz) {
        ReportSettings reportSettings = this.inspectAnnotation(clazz, "org.testng.annotations.BeforeSuite");
        if (reportSettings != null) {
            return reportSettings;
        }
        return this.inspectAnnotation(clazz, "org.testng.annotations.BeforeClass");
    }

    private ReportSettings inspectAnnotation(Class<?> clazz, String annotationName) {
        for (Method method : clazz.getDeclaredMethods()) {
            Optional<Annotation> annotation = Arrays.stream(method.getAnnotations()).filter(a -> a.annotationType().getName().equals(annotationName)).findFirst();
            if (annotation.isEmpty()) continue;
            try {
                Method descriptionMethod = annotation.get().annotationType().getDeclaredMethod("description", new Class[0]);
                String description = descriptionMethod.invoke((Object)annotation.get(), new Object[0]).toString();
                if (!StringUtils.isEmpty((CharSequence)description)) {
                    return new ReportSettings(this.getPackageName(clazz), description);
                }
                return null;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LOG.error("Failed to infer JobName from annotation", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    @Override
    public String inferTestName() {
        for (StackTraceElement stackTraceElement : this.traces) {
            boolean isTestNG;
            Class<?> clazz;
            try {
                clazz = Class.forName(stackTraceElement.getClassName());
            }
            catch (ClassNotFoundException e) {
                LOG.error("Failed to create an instance of a class", (Throwable)e);
                return this.traces.get(this.traces.size() - 1).getMethodName();
            }
            Optional<Method> method = Arrays.stream(clazz.getDeclaredMethods()).filter(m -> m.getName().equals(stackTraceElement.getMethodName())).findFirst();
            if (method.isEmpty() || !(isTestNG = Arrays.stream(method.get().getDeclaredAnnotations()).anyMatch(a -> a.annotationType().getName().startsWith("org.testng")))) continue;
            Optional<Annotation> testAnnotation = Arrays.stream(method.get().getDeclaredAnnotations()).filter(a -> a.annotationType().getName().equals("org.testng.annotations.Test")).findFirst();
            if (testAnnotation.isPresent()) {
                try {
                    Method testNameMethod = testAnnotation.get().annotationType().getDeclaredMethod("testName", new Class[0]);
                    Method descriptionMethod = testAnnotation.get().annotationType().getDeclaredMethod("description", new Class[0]);
                    String testName = testNameMethod.invoke((Object)testAnnotation.get(), new Object[0]).toString();
                    String description = descriptionMethod.invoke((Object)testAnnotation.get(), new Object[0]).toString();
                    StringBuilder result = new StringBuilder();
                    if (!StringUtils.isEmpty((CharSequence)testName)) {
                        result.append(testName);
                    }
                    if (!StringUtils.isEmpty((CharSequence)description)) {
                        if (result.length() != 0) {
                            result.append(" - ");
                        }
                        result.append(description);
                    }
                    if (result.length() == 0) {
                        return method.get().getName();
                    }
                    return result.toString();
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.error("Failed to infer Test name from @Test annotation", (Throwable)e);
                    return method.get().getName();
                }
            }
            Optional<Annotation> otherAnnotation = Arrays.stream(method.get().getDeclaredAnnotations()).filter(a -> a.annotationType().getName().startsWith("org.testng")).findFirst();
            if (otherAnnotation.isEmpty()) {
                LOG.warn("Something went wrong, method has TestNG annotations but none of them could be used.");
                return method.get().getName();
            }
            Optional<Method> descriptionMethod = Arrays.stream(otherAnnotation.get().annotationType().getDeclaredMethods()).filter(m -> m.getName().equals("description")).findFirst();
            if (descriptionMethod.isEmpty()) {
                LOG.debug("Something went wrong... encountered a TestNG annotation without a description method.");
                return method.get().getName();
            }
            try {
                String description = descriptionMethod.get().invoke((Object)otherAnnotation.get(), new Object[0]).toString();
                return !StringUtils.isEmpty((CharSequence)description) ? description : method.get().getName();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LOG.error("Failed to infer Test name from TestNG annotation description", (Throwable)e);
                return method.get().getName();
            }
        }
        return this.traces.get(this.traces.size() - 1).getMethodName();
    }
}

