/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.drivers.web;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.testproject.sdk.drivers.ReportingDriver;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.helpers.DriverHelper;
import io.testproject.sdk.internal.helpers.DriverShutdownThread;
import io.testproject.sdk.internal.helpers.ReportingCommandsExecutor;
import io.testproject.sdk.internal.reporting.Reporter;
import io.testproject.sdk.internal.rest.AgentClient;
import io.testproject.sdk.internal.rest.ReportSettings;
import java.net.MalformedURLException;
import java.net.URL;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerOptions;
import org.openqa.selenium.remote.CommandExecutor;

@SuppressFBWarnings(value={"NM_SAME_SIMPLE_NAME_AS_SUPERCLASS"}, justification="Minimize changes required in any migrated tests")
public class InternetExplorerDriver
extends org.openqa.selenium.ie.InternetExplorerDriver
implements ReportingDriver {
    private final DriverShutdownThread driverShutdownThread;
    private Reporter reporter = new Reporter(this, AgentClient.getClient(this.getCapabilities()));

    public InternetExplorerDriver() throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, new InternetExplorerOptions());
    }

    public InternetExplorerDriver(InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, boolean disableReports) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, null, null, disableReports);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, null, false);
    }

    public InternetExplorerDriver(InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, null, options, projectName, jobName, false);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, null, null, false);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, null, false);
    }

    public InternetExplorerDriver(String token, InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(null, token, options, projectName, jobName, false);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, null, null, false);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, null, false);
    }

    public InternetExplorerDriver(URL remoteAddress, InternetExplorerOptions options, String projectName, String jobName) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, null, options, projectName, jobName, false);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        this(remoteAddress, token, options, null, null, false);
    }

    public InternetExplorerDriver(URL remoteAddress, String token, InternetExplorerOptions options, String projectName, String jobName, boolean disableReports) throws InvalidTokenException, AgentConnectException, MalformedURLException, ObsoleteVersionException {
        super(new InternetExplorerOptions(AgentClient.getClient(remoteAddress, token, (Capabilities)options, new ReportSettings(projectName, jobName), disableReports).getSession().getCapabilities()));
        this.getReportingCommandExecutor().setReportsDisabled(disableReports);
        this.driverShutdownThread = new DriverShutdownThread(this);
        Runtime.getRuntime().addShutdownHook(this.driverShutdownThread);
    }

    protected void startSession(Capabilities capabilities) {
        try {
            AgentClient agentClient = AgentClient.getClient(capabilities);
            DriverHelper.setCapabilities((WebDriver)this, capabilities);
            this.setSessionId(agentClient.getSession().getSessionId());
            this.setCommandExecutor((CommandExecutor)DriverHelper.getHttpCommandExecutor(agentClient, false));
        }
        catch (Exception e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    public void quit() {
        Runtime.getRuntime().removeShutdownHook(this.driverShutdownThread);
        this.stop();
    }

    @Override
    public void stop() {
        ReportingCommandsExecutor executor = (ReportingCommandsExecutor)this.getCommandExecutor();
        executor.clearStash();
        super.quit();
    }

    @Override
    public Reporter report() {
        return this.reporter;
    }
}

