/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.reporting.inferrers;

import io.testproject.sdk.internal.reporting.inferrers.GenericInferrer;
import io.testproject.sdk.internal.reporting.inferrers.JUnitInferrer;
import io.testproject.sdk.internal.reporting.inferrers.ReportSettingsInferrer;
import io.testproject.sdk.internal.reporting.inferrers.TestNGInferrer;
import java.util.List;

public final class InferrerFactory {
    private InferrerFactory() {
    }

    public static ReportSettingsInferrer getInferrer(List<StackTraceElement> traces) {
        if (traces.stream().anyMatch(p -> p.getClassName().startsWith("org.junit"))) {
            return new JUnitInferrer(traces);
        }
        if (traces.stream().anyMatch(p -> p.getClassName().startsWith("org.testng"))) {
            return new TestNGInferrer(traces);
        }
        return new GenericInferrer(traces);
    }
}

