/*
 * Decompiled with CFR 0.152.
 */
package io.testproject.sdk.internal.rest;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import io.testproject.sdk.internal.addons.ActionProxy;
import io.testproject.sdk.internal.exceptions.AgentConnectException;
import io.testproject.sdk.internal.exceptions.InvalidTokenException;
import io.testproject.sdk.internal.exceptions.ObsoleteVersionException;
import io.testproject.sdk.internal.reporting.inferrers.GenericInferrer;
import io.testproject.sdk.internal.reporting.inferrers.InferrerFactory;
import io.testproject.sdk.internal.rest.AgentSession;
import io.testproject.sdk.internal.rest.ReportSettings;
import io.testproject.sdk.internal.rest.ReportsQueue;
import io.testproject.sdk.internal.rest.messages.ActionExecutionResponse;
import io.testproject.sdk.internal.rest.messages.DriverCommandReport;
import io.testproject.sdk.internal.rest.messages.SessionRequest;
import io.testproject.sdk.internal.rest.messages.SessionResponse;
import io.testproject.sdk.internal.rest.messages.StepReport;
import io.testproject.sdk.internal.rest.messages.TestReport;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AgentClient
implements Closeable {
    public static final int REPORTS_QUEUE_TIMEOUT = 10;
    private static final String TP_GUID = "tp:guid";
    private static final String TP_AGENT_URL = "TP_AGENT_URL";
    private static final String TP_DEV_TOKEN = "TP_DEV_TOKEN";
    private static final String AGENT_DEFAULT_API_ADDRESS = "http://localhost:8585";
    private static final int CONNECTION_TIMEOUT_MS = 5000;
    private static final int CONNECTION_REQUEST_TIMEOUT_MS = 5000;
    private static final int NEW_SESSION_SOCKET_TIMEOUT_MS = 120000;
    private static final int ADDON_EXECUTION_SOCKET_TIMEOUT_MS = 60000;
    private static final Logger LOG = LoggerFactory.getLogger(AgentClient.class);
    private static final HashMap<String, AgentClient> CLIENTS_MAP = new HashMap();
    private static final Gson GSON = new GsonBuilder().create();
    private final ExecutorService reportsExecutorService = Executors.newSingleThreadExecutor();
    private final URL remoteAddress;
    private final String token;
    private final CloseableHttpClient httpClient;
    private Future<?> reportsQueueFuture;
    private ReportsQueue reportsQueue;
    private AgentSession session;
    private Socket socket;
    private String projectName;
    private String jobName;

    private AgentClient(URL remoteAddress, String token, Capabilities capabilities, ReportSettings reportSettings, boolean disableReports) throws MalformedURLException, InvalidTokenException, AgentConnectException, ObsoleteVersionException {
        this.remoteAddress = remoteAddress != null ? remoteAddress : (!StringUtils.isEmpty((CharSequence)System.getenv(TP_AGENT_URL)) ? new URL(System.getenv(TP_AGENT_URL)) : new URL(AGENT_DEFAULT_API_ADDRESS));
        if (!StringUtils.isEmpty((CharSequence)token)) {
            this.token = token;
        } else if (!StringUtils.isEmpty((CharSequence)System.getenv(TP_DEV_TOKEN))) {
            this.token = System.getenv(TP_DEV_TOKEN);
        } else {
            throw new InvalidTokenException("No token has been provided.");
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().addInterceptorLast((request, context) -> {
            request.setHeader("Authorization", this.token);
            request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
            request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        });
        this.httpClient = httpClientBuilder.build();
        ReportSettings sessionReportSettings = disableReports ? null : this.inferReportSettings(reportSettings);
        this.startSession(capabilities, sessionReportSettings);
        if (!disableReports) {
            this.reportsQueue = new ReportsQueue(this.httpClient);
            this.reportsQueueFuture = this.reportsExecutorService.submit(this.reportsQueue);
        }
    }

    public static AgentClient getClient(Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, null, capabilities, null, false);
    }

    public static AgentClient getClient(Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, null, capabilities, reportSettings, true);
    }

    public static AgentClient getClient(String token, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, token, capabilities, null, false);
    }

    public static AgentClient getClient(String token, Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(null, token, capabilities, reportSettings, true);
    }

    public static AgentClient getClient(URL remoteAddress, Capabilities capabilities, ReportSettings reportSettings) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(remoteAddress, null, capabilities, reportSettings, true);
    }

    public static AgentClient getClient(URL remoteAddress, Capabilities capabilities) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        return AgentClient.getClient(remoteAddress, null, capabilities, null, false);
    }

    public static AgentClient getClient(URL remoteAddress, String token, Capabilities capabilities, ReportSettings reportSettings, boolean disableReports) throws AgentConnectException, InvalidTokenException, MalformedURLException, ObsoleteVersionException {
        String guid;
        if (!capabilities.asMap().containsKey(TP_GUID)) {
            MutableCapabilities newCapabilities = new MutableCapabilities();
            newCapabilities.setCapability(TP_GUID, UUID.randomUUID().toString());
            capabilities = capabilities.merge((Capabilities)newCapabilities);
        }
        if (!CLIENTS_MAP.containsKey(guid = capabilities.getCapability(TP_GUID).toString())) {
            AgentClient agentClient = new AgentClient(remoteAddress, token, capabilities, reportSettings, disableReports);
            CLIENTS_MAP.put(guid, agentClient);
        }
        return CLIENTS_MAP.get(guid);
    }

    public static void removeClient(Capabilities capabilities) {
        CLIENTS_MAP.remove(Objects.requireNonNull(capabilities.getCapability(TP_GUID)).toString()).close();
    }

    private RequestConfig getDefaultHttpConfig() {
        return RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(5000).build();
    }

    private void startSession(Capabilities capabilities, ReportSettings reportSettings) throws InvalidTokenException, AgentConnectException, ObsoleteVersionException {
        SessionResponse agentResponse;
        String responseBody;
        CloseableHttpResponse response;
        LOG.info("Initializing new session...");
        LOG.trace("Initializing new session with capabilities: {}", (Object)GSON.toJson((Object)capabilities));
        String guid = Objects.requireNonNull(capabilities.getCapability(TP_GUID)).toString();
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/session");
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(120000).build();
        httpPost.setConfig(config);
        SessionRequest request = new SessionRequest(reportSettings, capabilities.asMap());
        this.projectName = request.getProjectName();
        this.jobName = request.getJobName();
        StringEntity entity = new StringEntity(GSON.toJson((Object)request), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            throw new AgentConnectException("Failed communicating with the Agent at " + this.remoteAddress, e);
        }
        if (response.getStatusLine().getStatusCode() < 200 || response.getStatusLine().getStatusCode() >= 300) {
            this.handleSessionStartFailure(response);
            return;
        }
        try {
            responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOG.error("Failed reading Agent response", (Throwable)e);
            throw new AgentConnectException("Failed reading Agent response", e);
        }
        LOG.trace("Session initialized: {}", (Object)responseBody);
        try {
            agentResponse = (SessionResponse)GSON.fromJson(responseBody, SessionResponse.class);
        }
        catch (JsonSyntaxException e) {
            LOG.error("Failed to parse Agent response", (Throwable)e);
            throw new AgentConnectException("Failed to parse Agent response", e);
        }
        try {
            MutableCapabilities mutableCapabilities = new MutableCapabilities(agentResponse.getCapabilities());
            mutableCapabilities.setCapability(TP_GUID, guid);
            this.session = new AgentSession(new URL(agentResponse.getServerAddress()), agentResponse.getSessionId(), Dialect.valueOf((String)agentResponse.getDialect()), (Capabilities)mutableCapabilities);
        }
        catch (MalformedURLException e) {
            LOG.error("Agent returned an invalid server URL: [{}]", (Object)agentResponse.getServerAddress(), (Object)e);
            throw new AgentConnectException("Failed initializing a session", e);
        }
        try {
            this.socket = new Socket(this.remoteAddress.getHost(), agentResponse.getDevSocketPort());
        }
        catch (IOException e) {
            LOG.error("Failed connecting to Agent socket at {}:{}", new Object[]{this.remoteAddress.getHost(), agentResponse.getDevSocketPort(), e});
            throw new AgentConnectException("Failed connecting to Agent socket", e);
        }
    }

    private ReportSettings inferReportSettings(ReportSettings reportSettings) {
        if (reportSettings != null && !StringUtils.isEmpty((CharSequence)reportSettings.getProjectName()) && !StringUtils.isEmpty((CharSequence)reportSettings.getJobName())) {
            LOG.trace("Project and Job names were explicitly set, skipping inferring.");
            return reportSettings;
        }
        LOG.trace("Report settings were not provided or incomplete, trying to infer...");
        List<StackTraceElement> traces = Arrays.asList(Thread.currentThread().getStackTrace());
        ReportSettings inferredReportSettings = InferrerFactory.getInferrer(traces).inferReportSettings();
        if (inferredReportSettings == null) {
            inferredReportSettings = new GenericInferrer(traces).inferReportSettings();
        }
        LOG.info("Inferred [{}] and [{}] for Project and Job names accordingly.", (Object)inferredReportSettings.getProjectName(), (Object)inferredReportSettings.getJobName());
        ReportSettings result = reportSettings != null ? new ReportSettings(!StringUtils.isEmpty((CharSequence)reportSettings.getProjectName()) ? reportSettings.getProjectName() : inferredReportSettings.getProjectName(), !StringUtils.isEmpty((CharSequence)reportSettings.getJobName()) ? reportSettings.getJobName() : inferredReportSettings.getJobName()) : inferredReportSettings;
        LOG.info("Using [{}] and [{}] for Project and Job names accordingly.", (Object)result.getProjectName(), (Object)result.getJobName());
        return result;
    }

    private void handleSessionStartFailure(CloseableHttpResponse response) throws InvalidTokenException, ObsoleteVersionException, AgentConnectException {
        String statusMessage = null;
        try {
            String responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
            JsonObject json = (JsonObject)new JsonParser().parse(responseBody);
            JsonElement message = json.get("message");
            statusMessage = message != null && !message.isJsonNull() ? message.getAsString() : null;
        }
        catch (IOException e) {
            LOG.error("Failed reading Agent response", (Throwable)e);
        }
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                LOG.error("Failed to initialize a session with the Agent - token is invalid");
                throw new InvalidTokenException();
            }
            case 406: {
                LOG.error("Failed to initialize a session with the Agent - obsolete SDK version");
                throw new ObsoleteVersionException(statusMessage);
            }
        }
        LOG.error("Failed to initialize a session with the Agent");
        throw new AgentConnectException("Agent responded with status " + response.getStatusLine().getStatusCode() + ": [" + statusMessage + "]");
    }

    public AgentSession getSession() {
        return this.session;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getJobName() {
        return this.jobName;
    }

    public ReportSettings getReportSetting() {
        if (StringUtils.isEmpty((CharSequence)this.projectName) || StringUtils.isEmpty((CharSequence)this.jobName)) {
            return null;
        }
        return new ReportSettings(this.projectName, this.jobName);
    }

    @Override
    public void close() {
        if (this.reportsQueueFuture != null && !this.reportsQueueFuture.isDone()) {
            this.reportsQueue.stop();
            try {
                this.reportsQueueFuture.get(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                LOG.error("Reports queue was interrupted while sending reports.");
            }
            catch (ExecutionException e) {
                LOG.error("Reports queue has thrown an exception", ExceptionUtils.getRootCause((Throwable)e));
            }
            catch (TimeoutException e) {
                LOG.error("Reports queue didn't finish uploading reports in a timely manner and was terminated.");
            }
            if (!this.reportsQueueFuture.isDone()) {
                LOG.warn("Terminating reports queue forcibly...");
                this.reportsQueueFuture.cancel(true);
            }
        }
        if (!this.reportsExecutorService.isTerminated()) {
            this.reportsExecutorService.shutdown();
        }
        if (this.socket != null && this.socket.isConnected()) {
            try {
                this.socket.close();
                LOG.info("Session closed.");
            }
            catch (IOException e) {
                LOG.error("Failed closing socket connected to the Agent at {}", (Object)this.remoteAddress, (Object)e);
            }
        }
    }

    public boolean reportCommand(Command command, Object result, boolean passed) {
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/command");
        httpPost.setConfig(this.getDefaultHttpConfig());
        DriverCommandReport report = new DriverCommandReport(command.getName(), command.getParameters(), result, passed);
        StringEntity entity = new StringEntity(GSON.toJson((Object)report), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public boolean reportStep(StepReport report) {
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/step");
        httpPost.setConfig(this.getDefaultHttpConfig());
        StringEntity entity = new StringEntity(GSON.toJson((Object)report), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public boolean reportTest(TestReport report) {
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/development/report/test");
        httpPost.setConfig(this.getDefaultHttpConfig());
        StringEntity entity = new StringEntity(GSON.toJson((Object)report), StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        this.reportsQueue.submit((HttpEntityEnclosingRequestBase)httpPost, report);
        return true;
    }

    public ActionExecutionResponse executeProxy(ActionProxy action, int timeout) throws WebDriverException {
        String responseBody;
        CloseableHttpResponse response;
        HttpPost httpPost = new HttpPost(this.remoteAddress + "/api/addons/executions");
        RequestConfig config = RequestConfig.custom().setConnectionRequestTimeout(5000).setConnectTimeout(5000).setSocketTimeout(timeout > 0 ? timeout : 60000).build();
        httpPost.setConfig(config);
        HashMap parameters = (HashMap)GSON.fromJson(GSON.toJsonTree((Object)action).toString(), HashMap.class);
        action.getDescriptor().setParameters(parameters);
        String request = GSON.toJson((Object)action.getDescriptor());
        LOG.trace("Sending action proxy request: {}", (Object)request);
        StringEntity entity = new StringEntity(request, StandardCharsets.UTF_8);
        httpPost.setEntity((HttpEntity)entity);
        try {
            response = this.httpClient.execute((HttpUriRequest)httpPost);
        }
        catch (IOException e) {
            LOG.error("Failed to execute action proxy: [{}]", (Object)action, (Object)e);
            throw new WebDriverException("Failed to execute action proxy: [" + action + "]", (Throwable)e);
        }
        if (response != null && response.getStatusLine().getStatusCode() != 200) {
            LOG.error("Agent responded with an unexpected status {} to action proxy execution: [{}]", (Object)response.getStatusLine().getStatusCode(), (Object)action);
        }
        if (response == null) {
            LOG.error("Agent response is empty");
            throw new WebDriverException("Failed to execute action proxy: [" + action + "]");
        }
        try {
            responseBody = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException e) {
            LOG.error("Failed reading action proxy execution response", (Throwable)e);
            throw new WebDriverException("Failed reading action proxy execution response", (Throwable)e);
        }
        return (ActionExecutionResponse)GSON.fromJson(responseBody, ActionExecutionResponse.class);
    }

    private static class Routes {
        static final String DEVELOPMENT_SESSION = "/api/development/session";
        static final String REPORT_COMMAND = "/api/development/report/command";
        static final String REPORT_STEP = "/api/development/report/step";
        static final String REPORT_TEST = "/api/development/report/test";
        static final String EXECUTE_ACTION_PROXY = "/api/addons/executions";

        private Routes() {
        }
    }
}

