/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.sender;

import io.testomat.core.client.http.NativeHttpClient;
import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import io.testomat.junit.methodexporter.ExporterRequestBodyBuilder;
import io.testomat.junit.model.ExporterTestCase;
import java.util.List;

public class ExportSender {
    private static final String LOAD_URL = "https://app.testomat.io/api/load?api_key=";
    private static final int RETRY_TIMEOUT_MILLISECONDS = 1500;
    private static final int RETRY_MAX_ATTEMPTS = 2;
    private final PropertyProvider provider;

    public ExportSender() {
        this.provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    }

    public ExportSender(PropertyProvider provider) {
        this.provider = provider;
    }

    public void sendTestCases(List<ExporterTestCase> exporterTestCases) {
        if (exporterTestCases.isEmpty()) {
            return;
        }
        ExporterRequestBodyBuilder exporterRequestBodyBuilder = new ExporterRequestBodyBuilder();
        NativeHttpClient client = new NativeHttpClient();
        String requestBody = exporterRequestBodyBuilder.buildRequestBody(exporterTestCases);
        String url = LOAD_URL + this.provider.getProperty("testomatio.api.key");
        for (int attempt = 1; attempt <= 2; ++attempt) {
            try {
                if (attempt > 1) {
                    Thread.sleep(1500L);
                }
                client.post(url, requestBody, null);
                return;
            }
            catch (Exception e) {
                boolean isLastAttempt;
                boolean is422Error = e.getMessage().contains("422");
                boolean bl = isLastAttempt = attempt == 2;
                if (is422Error && !isLastAttempt) continue;
                e.printStackTrace();
                break;
            }
        }
    }
}

