/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.reporter;

import io.testomat.core.exception.ReportTestResultException;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.junit.constructor.JUnitTestResultConstructor;
import io.testomat.junit.extractor.JunitMetaDataExtractor;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JunitTestReporter {
    private final JUnitTestResultConstructor resultConstructor;
    private final JunitMetaDataExtractor metaDataExtractor;
    private final GlobalRunManager runManager;

    public JunitTestReporter() {
        this.resultConstructor = new JUnitTestResultConstructor();
        this.metaDataExtractor = new JunitMetaDataExtractor();
        this.runManager = GlobalRunManager.getInstance();
    }

    public JunitTestReporter(JUnitTestResultConstructor resultConstructor, JunitMetaDataExtractor metaDataExtractor, GlobalRunManager runManager) {
        this.runManager = runManager;
        this.resultConstructor = resultConstructor;
        this.metaDataExtractor = metaDataExtractor;
    }

    public void reportTestResult(ExtensionContext context, String status, String message) {
        if (!this.runManager.isActive()) {
            return;
        }
        TestMetadata metadata = null;
        try {
            metadata = this.metaDataExtractor.extractTestMetadata(context);
            TestResult result = this.resultConstructor.constructTestRunResult(metadata, message, status, context);
            this.runManager.reportTest(result);
        }
        catch (Exception e) {
            String testName = metadata != null ? metadata.getTitle() : "Unknown Test";
            throw new ReportTestResultException("Failed to report test result for: " + testName, (Throwable)e);
        }
    }
}

