/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.listener;

import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.junit.methodexporter.MethodExportManager;
import io.testomat.junit.reporter.JunitTestReporter;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestWatcher;

public class JunitListener
implements BeforeEachCallback,
BeforeAllCallback,
AfterAllCallback,
TestWatcher {
    private final MethodExportManager methodExportManager;
    private final GlobalRunManager runManager;
    private final JunitTestReporter reporter;

    public JunitListener() {
        this.methodExportManager = new MethodExportManager();
        this.runManager = GlobalRunManager.getInstance();
        this.reporter = new JunitTestReporter();
    }

    public JunitListener(MethodExportManager methodExportManager, GlobalRunManager runManager, JunitTestReporter reporter) {
        this.methodExportManager = methodExportManager;
        this.runManager = runManager;
        this.reporter = reporter;
    }

    public void beforeAll(ExtensionContext context) {
        this.runManager.incrementSuiteCounter();
    }

    public void afterAll(ExtensionContext context) {
        this.runManager.decrementSuiteCounter();
        this.methodExportManager.loadTestBodyIfRequired(context);
    }

    public void beforeEach(ExtensionContext extensionContext) {
    }

    public void testDisabled(ExtensionContext context, Optional<String> reason) {
        this.reporter.reportTestResult(context, "skipped", reason.orElse("Test disabled"));
    }

    public void testSuccessful(ExtensionContext context) {
        this.reporter.reportTestResult(context, "passed", null);
    }

    public void testAborted(ExtensionContext context, Throwable cause) {
        this.reporter.reportTestResult(context, "skipped", cause.getMessage());
    }

    public void testFailed(ExtensionContext context, Throwable cause) {
        this.reporter.reportTestResult(context, "failed", cause.getMessage());
    }
}

