/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.constructor;

import io.testomat.core.model.ExceptionDetails;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitTestResultConstructor {
    private static final Logger log = LoggerFactory.getLogger(JUnitTestResultConstructor.class);

    public TestResult constructTestRunResult(TestMetadata metadata, String message, String status, ExtensionContext context) {
        String stack;
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata is null");
        }
        if (message != null) {
            log.debug("Creating JUnit test result with custom message: {} - {}", (Object)metadata.getTitle(), (Object)message);
            stack = this.extractStackTrace(context);
        } else {
            log.debug("Creating JUnit test result with exception details for: {}", (Object)metadata.getTitle());
            ExceptionDetails details = this.extractExceptionDetails(context);
            message = details.getMessage();
            stack = details.getStack();
        }
        return this.createTestResult(metadata, message, status, stack);
    }

    private TestResult createTestResult(TestMetadata metadata, String message, String status, String stack) {
        return TestResult.builder().withSuiteTitle(metadata.getSuiteTitle()).withTestId(metadata.getTestId()).withTitle(metadata.getTitle()).withFile(metadata.getFile()).withMessage(message).withStatus(status).withStack(stack).build();
    }

    private ExceptionDetails extractExceptionDetails(ExtensionContext context) {
        return Optional.ofNullable(context).flatMap(ExtensionContext::getExecutionException).filter(this::isReportableException).map(this::createExceptionDetails).orElse(ExceptionDetails.empty());
    }

    private String extractStackTrace(ExtensionContext context) {
        return Optional.ofNullable(context).flatMap(ExtensionContext::getExecutionException).filter(this::isReportableException).map(this::getStackTrace).orElse(null);
    }

    private ExceptionDetails createExceptionDetails(Throwable throwable) {
        String message = throwable.getMessage();
        String stack = this.getStackTrace(throwable);
        log.debug("Including error details for failed test");
        return new ExceptionDetails(message, stack);
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }

    private boolean isReportableException(Throwable throwable) {
        return !(throwable instanceof TestAbortedException);
    }
}

