/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.model;

public class TestResult {
    private String title;
    private String testId;
    private String suiteTitle;
    private String file;
    private String status;
    private String message;
    private String stack;

    public TestResult() {
    }

    public TestResult(String title, String testId, String suiteTitle, String file, String status, String message, String stack) {
        this.title = title;
        this.testId = testId;
        this.suiteTitle = suiteTitle;
        this.file = file;
        this.status = status;
        this.message = message;
        this.stack = stack;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTestId() {
        return this.testId;
    }

    public void setTestId(String testId) {
        this.testId = testId;
    }

    public String getSuiteTitle() {
        return this.suiteTitle;
    }

    public void setSuiteTitle(String suiteTitle) {
        this.suiteTitle = suiteTitle;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    public static class Builder {
        private String title;
        private String testId;
        private String suiteTitle;
        private String file;
        private String status;
        private String message;
        private String stack;

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withTestId(String testId) {
            this.testId = testId;
            return this;
        }

        public Builder withSuiteTitle(String suiteTitle) {
            this.suiteTitle = suiteTitle;
            return this;
        }

        public Builder withFile(String file) {
            this.file = file;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withStack(String stack) {
            this.stack = stack;
            return this;
        }

        public TestResult build() {
            return new TestResult(this.title, this.testId, this.suiteTitle, this.file, this.status, this.message, this.stack);
        }
    }
}

