/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.patfinder;

import io.testomat.junit.exception.MethodExporterException;
import io.testomat.junit.methodexporter.patfinder.PathNormalizer;
import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileFinder {
    private static final Logger log = LoggerFactory.getLogger(FileFinder.class);
    private static final String FILE_SEPARATOR = FileSystems.getDefault().getSeparator();
    private final PathNormalizer normalizer;

    public FileFinder() {
        this.normalizer = new PathNormalizer();
    }

    public FileFinder(PathNormalizer normalizer) {
        this.normalizer = normalizer;
    }

    public String getTestClassFilePath(ExtensionContext extensionContext) {
        String foundFile = this.findTestFileByClassName(extensionContext);
        if (foundFile != null && !foundFile.equals(this.getDefaultPath(extensionContext))) {
            return foundFile;
        }
        try {
            String javaFilePath;
            String path = this.getPath(extensionContext);
            if (path != null && (javaFilePath = this.convertClassPathToJavaFile(path, extensionContext)) != null && Paths.get(javaFilePath, new String[0]).toFile().exists()) {
                return javaFilePath;
            }
        }
        catch (Exception e) {
            log.debug("Error getting test class file path: {}", (Object)e.getMessage(), (Object)e);
        }
        return foundFile;
    }

    private String convertClassPathToJavaFile(String classPath, ExtensionContext extensionContext) {
        try {
            Class testClass = extensionContext.getRequiredTestClass();
            String className = testClass.getName();
            String packagePath = className.replace(".", FILE_SEPARATOR);
            if (classPath.contains("target" + FILE_SEPARATOR + "test-classes")) {
                String projectRoot = classPath.substring(0, classPath.indexOf("target" + FILE_SEPARATOR + "test-classes"));
                String javaFilePath = projectRoot + "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + packagePath + ".java";
                return this.normalizer.normalizePath(javaFilePath);
            }
            if (classPath.endsWith(".class")) {
                String withoutExtension = classPath.substring(0, classPath.length() - 6);
                return withoutExtension + ".java";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public String getPath(ExtensionContext context) {
        try {
            Class testClass = (Class)context.getTestClass().orElseThrow(() -> new MethodExporterException("No test class found"));
            URI uri = testClass.getProtectionDomain().getCodeSource().getLocation().toURI();
            return URLDecoder.decode(uri.getPath(), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.debug("Error getting path from context: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    private String findTestFileByClassName(ExtensionContext extensionContext) {
        try {
            Class testClass = extensionContext.getRequiredTestClass();
            String className = testClass.getName();
            String relativePath = className.replace(".", FILE_SEPARATOR) + ".java";
            List<String> possiblePaths = Arrays.asList("src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + relativePath, ".." + FILE_SEPARATOR + "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + relativePath, "test" + FILE_SEPARATOR + relativePath, relativePath);
            for (String path : possiblePaths) {
                File file = new File(path);
                if (!file.exists()) continue;
                String absolutePath = file.getAbsolutePath();
                return this.normalizer.normalizePath(absolutePath);
            }
            String workingDir = System.getProperty("user.dir");
            List<String> workingDirPaths = Arrays.asList(workingDir + FILE_SEPARATOR + "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + relativePath, workingDir + FILE_SEPARATOR + ".." + FILE_SEPARATOR + "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + relativePath);
            for (String path : workingDirPaths) {
                File file = new File(path);
                if (!file.exists()) continue;
                return this.normalizer.normalizePath(file.getAbsolutePath());
            }
            return this.getDefaultPath(extensionContext);
        }
        catch (Exception e) {
            log.debug("Error finding test file by class name: {}", (Object)e.getMessage(), (Object)e);
            return this.getDefaultPath(extensionContext);
        }
    }

    private String getDefaultPath(ExtensionContext extensionContext) {
        try {
            Class testClass = extensionContext.getRequiredTestClass();
            String relativePath = testClass.getName().replace(".", FILE_SEPARATOR) + ".java";
            return "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + relativePath;
        }
        catch (Exception e) {
            return "src" + FILE_SEPARATOR + "test" + FILE_SEPARATOR + "java" + FILE_SEPARATOR + "UnknownTest.java";
        }
    }

    public String extractRelativeFilePath(String filepath) {
        try {
            if (filepath == null || filepath.isEmpty()) {
                return "src/test/java/UnknownFile.java";
            }
            String normalizedPath = this.normalizer.normalizePath(filepath);
            int srcIndex = normalizedPath.indexOf("src/");
            if (srcIndex != -1) {
                return normalizedPath.substring(srcIndex);
            }
            return normalizedPath;
        }
        catch (Exception e) {
            log.debug("Error extracting relative file path: {}", (Object)e.getMessage(), (Object)e);
            return "src/test/java/UnknownFile.java";
        }
    }
}

