/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.methodexporter.extractors;

import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import io.testomat.junit.methodexporter.extractors.LabelExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class MethodInfoExtractor {
    private static final String DISPLAY_NAME_ANNOTATION = "DisplayName";
    private static final String DISABLED_ANNOTATION = "Disabled";
    private static final String IGNORE_ANNOTATION = "Ignore";
    private static final String IGNORE_METHOD_PREFIX = "ignore";
    private static final String SKIP_METHOD_PREFIX = "skip";
    private final LabelExtractor labelExtractor;

    public MethodInfoExtractor() {
        this.labelExtractor = new LabelExtractor();
    }

    public MethodInfoExtractor(LabelExtractor labelExtractor) {
        this.labelExtractor = labelExtractor;
    }

    public String getTestName(MethodDeclaration method) {
        return this.safeExecute(() -> {
            String displayName = this.extractDisplayName(method);
            return displayName != null ? displayName : method.getNameAsString();
        }, method.getNameAsString());
    }

    public String getMethodCode(MethodDeclaration method) {
        return this.safeExecute(() -> this.buildMethodCode(method), method.toString());
    }

    public boolean isTestSkipped(MethodDeclaration method) {
        return this.safeExecute(() -> this.hasSkipAnnotations(method) || this.hasSkipMethodName(method), false);
    }

    public List<String> extractSuites(MethodDeclaration testMethod) {
        return this.safeExecute(() -> this.buildSuiteHierarchy(testMethod), this.createFallbackSuites(testMethod));
    }

    private <T> T safeExecute(SafeOperation<T> operation, T fallbackValue) {
        try {
            return operation.execute();
        }
        catch (Exception e) {
            return fallbackValue;
        }
    }

    private String extractDisplayName(MethodDeclaration method) {
        return method.getAnnotations().stream().filter(ann -> ann.getNameAsString().equals(DISPLAY_NAME_ANNOTATION)).findFirst().map(this.labelExtractor::getAnnotationValue).orElse(null);
    }

    private String buildMethodCode(MethodDeclaration method) {
        StringBuilder code = new StringBuilder();
        this.appendAllAnnotations(code, method);
        this.appendMethodSignature(code, method);
        this.appendMethodBody(code, method);
        return code.toString();
    }

    private void appendAllAnnotations(StringBuilder code, MethodDeclaration method) {
        method.getAnnotations().forEach(annotation -> code.append(annotation.toString()).append("\n"));
    }

    private void appendMethodSignature(StringBuilder code, MethodDeclaration method) {
        this.appendModifiers(code, method);
        this.appendReturnTypeAndName(code, method);
        this.appendParameters(code, method);
        this.appendThrownExceptions(code, method);
    }

    private void appendModifiers(StringBuilder code, MethodDeclaration method) {
        method.getModifiers().forEach(modifier -> code.append(modifier.getKeyword().asString()).append(" "));
    }

    private void appendReturnTypeAndName(StringBuilder code, MethodDeclaration method) {
        code.append(method.getTypeAsString()).append(" ").append(method.getNameAsString()).append("(");
    }

    private void appendParameters(StringBuilder code, MethodDeclaration method) {
        if (!method.getParameters().isEmpty()) {
            for (int i = 0; i < method.getParameters().size(); ++i) {
                if (i > 0) {
                    code.append(", ");
                }
                code.append(method.getParameter(i).toString());
            }
        }
        code.append(")");
    }

    private void appendThrownExceptions(StringBuilder code, MethodDeclaration method) {
        if (!method.getThrownExceptions().isEmpty()) {
            code.append(" throws ");
            for (int i = 0; i < method.getThrownExceptions().size(); ++i) {
                if (i > 0) {
                    code.append(", ");
                }
                code.append(method.getThrownException(i).toString());
            }
        }
    }

    private void appendMethodBody(StringBuilder code, MethodDeclaration method) {
        Optional body = method.getBody();
        body.ifPresent(blockStmt -> code.append(" ").append(blockStmt));
    }

    private boolean hasSkipAnnotations(MethodDeclaration method) {
        return method.getAnnotations().stream().anyMatch(ann -> ann.getNameAsString().equals(DISABLED_ANNOTATION) || ann.getNameAsString().equals(IGNORE_ANNOTATION));
    }

    private boolean hasSkipMethodName(MethodDeclaration method) {
        String methodName = method.getNameAsString();
        return methodName.startsWith(IGNORE_METHOD_PREFIX) || methodName.startsWith(SKIP_METHOD_PREFIX);
    }

    private List<String> buildSuiteHierarchy(MethodDeclaration testMethod) {
        ArrayList<String> suites = new ArrayList<String>();
        List<ClassOrInterfaceDeclaration> classHierarchy = this.collectClassHierarchy(testMethod);
        for (ClassOrInterfaceDeclaration clazz : classHierarchy) {
            String suiteName = this.extractSuiteName(clazz);
            suites.add(suiteName);
        }
        return suites;
    }

    private List<ClassOrInterfaceDeclaration> collectClassHierarchy(MethodDeclaration testMethod) {
        ArrayList<ClassOrInterfaceDeclaration> classHierarchy = new ArrayList<ClassOrInterfaceDeclaration>();
        ClassOrInterfaceDeclaration currentClass = testMethod.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).orElse(null);
        while (currentClass != null) {
            classHierarchy.add(0, currentClass);
            currentClass = currentClass.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).orElse(null);
        }
        return classHierarchy;
    }

    private String extractSuiteName(ClassOrInterfaceDeclaration clazz) {
        return clazz.getAnnotationByName(DISPLAY_NAME_ANNOTATION).map(this.labelExtractor::getAnnotationValue).orElse(clazz.getNameAsString());
    }

    private List<String> createFallbackSuites(MethodDeclaration testMethod) {
        ArrayList<String> suites = new ArrayList<String>();
        testMethod.findAncestor(new Class[]{ClassOrInterfaceDeclaration.class}).ifPresent(clazz -> suites.add(clazz.getNameAsString()));
        return suites;
    }

    @FunctionalInterface
    private static interface SafeOperation<T> {
        public T execute() throws Exception;
    }
}

