/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.junit.extractor;

import io.testomat.core.annotation.TestId;
import io.testomat.core.annotation.Title;
import io.testomat.core.exception.NoMethodInContextException;
import io.testomat.core.model.TestMetadata;
import java.lang.reflect.Method;
import org.junit.jupiter.api.extension.ExtensionContext;

public class JunitMetaDataExtractor {
    public TestMetadata extractTestMetadata(ExtensionContext context) {
        Method testMethod = this.getTestMethod(context);
        String title = this.getJUnitTestTitle(context);
        String suiteTitle = context.getTestClass().map(Class::getSimpleName).orElse("Unknown");
        String file = suiteTitle + ".java";
        String testId = this.getTestId(testMethod);
        return new TestMetadata(title, testId, suiteTitle, file);
    }

    private String getJUnitTestTitle(ExtensionContext context) {
        Title titleAnnotation = this.getTestMethod(context).getAnnotation(Title.class);
        return titleAnnotation != null ? titleAnnotation.value() : context.getDisplayName();
    }

    private String getTestId(Method method) {
        TestId testIdAnnotation = method.getAnnotation(TestId.class);
        return testIdAnnotation != null ? testIdAnnotation.value() : null;
    }

    private Method getTestMethod(ExtensionContext context) {
        return (Method)context.getTestMethod().orElseThrow(() -> new NoMethodInContextException("No test method found in " + context.getDisplayName()));
    }
}

