/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.cucumber.listener;

import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.Plugin;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.testomat.core.exception.ReportTestResultException;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.cucumber.constructor.CucumberTestResultConstructor;
import io.testomat.cucumber.constructor.TestResultWrapper;
import io.testomat.cucumber.extractor.CucumberMetaDataExtractor;

public class CucumberListener
implements Plugin,
EventListener {
    private final GlobalRunManager runManager = GlobalRunManager.getInstance();
    private final CucumberMetaDataExtractor metaDataExtractor = new CucumberMetaDataExtractor();
    private final CucumberTestResultConstructor resultConstructor = new CucumberTestResultConstructor();

    public void setEventPublisher(EventPublisher eventPublisher) {
        eventPublisher.registerHandlerFor(TestRunStarted.class, e -> this.runManager.incrementSuiteCounter());
        eventPublisher.registerHandlerFor(TestRunFinished.class, e -> this.runManager.decrementSuiteCounter());
        eventPublisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
    }

    void handleTestCaseFinished(TestCaseFinished event) {
        if (!this.runManager.isActive()) {
            return;
        }
        try {
            String status = this.normalizeStatus(event.getResult() != null ? event.getResult().getStatus() : null);
            TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(event.getTestCase());
            TestResultWrapper wrapper = TestResultWrapper.builder().withTestMetadata(metadata).withStatus(status).withCucumberTestCaseFinished(event).build();
            TestResult result = this.resultConstructor.constructTestRunResult(wrapper);
            this.runManager.reportTest(result);
        }
        catch (Exception e) {
            String testName = event.getTestCase() != null ? event.getTestCase().getName() : "Unknown Test";
            throw new ReportTestResultException("Failed to report test result for: " + testName, e);
        }
    }

    private String normalizeStatus(Object frameworkStatus) {
        if (frameworkStatus == null) {
            return "failed";
        }
        switch (frameworkStatus.toString().toUpperCase()) {
            case "PASSED": 
            case "SUCCESS": 
            case "SUCCESSFUL": {
                return "passed";
            }
            case "SKIPPED": 
            case "PENDING": 
            case "UNDEFINED": 
            case "AMBIGUOUS": 
            case "DISABLED": 
            case "ABORTED": {
                return "skipped";
            }
        }
        return "failed";
    }
}

