/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.client;

import io.testomat.core.client.ApiInterface;
import io.testomat.core.client.ClientFactory;
import io.testomat.core.client.NativeApiClient;
import io.testomat.core.client.http.NativeHttpClient;
import io.testomat.core.client.request.NativeRequestBodyBuilder;
import io.testomat.core.exception.ApiKeyNotFoundException;
import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestomatClientFactory
implements ClientFactory {
    private static final PropertyProvider propertyProvider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    private static final Logger log = LoggerFactory.getLogger(TestomatClientFactory.class);
    private static ClientFactory instance;

    private TestomatClientFactory() {
    }

    public static ClientFactory getClientFactory() {
        if (instance == null) {
            instance = new TestomatClientFactory();
        }
        return instance;
    }

    @Override
    public ApiInterface createClient() {
        String apiKey = propertyProvider.getProperty("testomatio.api.key");
        if (apiKey == null) {
            log.error("Api key environment variable not set.");
            throw new ApiKeyNotFoundException("Api key should be set in properties file or in JVM params.");
        }
        return new NativeApiClient(apiKey, new NativeHttpClient(), new NativeRequestBodyBuilder());
    }
}

