/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.runmanager;

import io.testomat.core.batch.BatchResultManager;
import io.testomat.core.client.ApiInterface;
import io.testomat.core.client.ClientFactory;
import io.testomat.core.client.TestomatClientFactory;
import io.testomat.core.model.TestResult;
import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalRunManager {
    private static final GlobalRunManager INSTANCE = new GlobalRunManager();
    private static final Logger log = LoggerFactory.getLogger(GlobalRunManager.class);
    private final PropertyProvider provider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
    private final AtomicInteger activeSuites = new AtomicInteger(0);
    private final AtomicReference<String> runUid = new AtomicReference();
    private final AtomicReference<BatchResultManager> batchManager = new AtomicReference();
    private final AtomicReference<ApiInterface> apiClient = new AtomicReference();
    private final AtomicBoolean shutdownHookRegistered = new AtomicBoolean(false);
    private volatile long startTime;

    private GlobalRunManager() {
    }

    public static GlobalRunManager getInstance() {
        return INSTANCE;
    }

    public synchronized void initializeIfNeeded() {
        if (this.runUid.get() != null) {
            return;
        }
        try {
            ClientFactory clientFactory = TestomatClientFactory.getClientFactory();
            ApiInterface client = clientFactory.createClient();
            String uid = this.getCustomRunUid(client);
            this.apiClient.set(client);
            this.runUid.set(uid);
            this.batchManager.set(new BatchResultManager(client, uid));
            this.startTime = System.currentTimeMillis();
            this.registerShutdownHook();
            log.debug("Global test run initialized with UID: {}", (Object)uid);
        }
        catch (Exception e) {
            log.error("Failed to initialize test run: {}", (Object)String.valueOf(e));
        }
    }

    private void registerShutdownHook() {
        if (this.shutdownHookRegistered.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                log.debug("JVM is shutting down, finalizing test run...");
                this.finalizeRun();
            }, "TestRunFinalizer"));
            log.debug("Shutdown hook registered for test run finalization");
        }
    }

    public void incrementSuiteCounter() {
        this.activeSuites.incrementAndGet();
        this.initializeIfNeeded();
    }

    public void decrementSuiteCounter() {
        int remaining = this.activeSuites.decrementAndGet();
        log.debug("Active suites remaining: {}", (Object)remaining);
    }

    public void reportTest(TestResult result) {
        BatchResultManager manager = this.batchManager.get();
        if (manager != null) {
            manager.addResult(result);
        }
    }

    public boolean isActive() {
        return this.runUid.get() != null;
    }

    private void finalizeRun() {
        BatchResultManager manager = this.batchManager.getAndSet(null);
        if (manager != null) {
            manager.shutdown();
        }
        String uid = this.runUid.getAndSet(null);
        ApiInterface client = this.apiClient.getAndSet(null);
        if (uid != null && client != null) {
            try {
                float duration = (float)(System.currentTimeMillis() - this.startTime) / 1000.0f;
                client.finishTestRun(uid, duration);
                log.debug("Test run finished: {}", (Object)uid);
            }
            catch (IOException e) {
                log.error("Failed to finish test run{}", (Object)String.valueOf(e.getCause()));
            }
        }
    }

    private String getRunTitle() {
        return PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider().getProperty("testomatio.run.title");
    }

    private String getCustomRunUid(ApiInterface client) throws IOException {
        String customUid;
        try {
            customUid = this.provider.getProperty("testomatio.run.id");
        }
        catch (Exception e) {
            customUid = client.createRun(this.getRunTitle());
        }
        return customUid;
    }
}

