/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.testng.extractor;

import io.testomat.core.annotation.TestId;
import io.testomat.core.annotation.Title;
import io.testomat.core.model.TestMetadata;
import io.testomat.testng.extractor.TestNgTestWrapper;
import java.lang.reflect.Method;
import org.testng.ITestResult;

public class TestNgMetaDataExtractor {
    public TestMetadata extractTestMetadata(TestNgTestWrapper wrapper) {
        String suiteTitle;
        Method method;
        if (wrapper.isRegularTest()) {
            ITestResult testResult = wrapper.getTestResult();
            method = testResult.getMethod().getConstructorOrMethod().getMethod();
            suiteTitle = testResult.getTestClass().getName();
        } else {
            method = wrapper.getMethod();
            suiteTitle = wrapper.getTestClass().getSimpleName();
        }
        String title = this.getTestTitle(method);
        String testId = this.getTestId(method);
        String file = suiteTitle + ".java";
        return new TestMetadata(title, testId, suiteTitle, file);
    }

    private String getTestId(Method method) {
        TestId testIdAnnotation = method.getAnnotation(TestId.class);
        return testIdAnnotation != null ? testIdAnnotation.value() : null;
    }

    private String getTestTitle(Method method) {
        Title titleAnnotation = method.getAnnotation(Title.class);
        return titleAnnotation != null ? titleAnnotation.value() : method.getName();
    }
}

