/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.testng.listener;

import io.testomat.core.exception.ReportTestResultException;
import io.testomat.core.exception.TestClassNotFoundException;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.core.runmanager.GlobalRunManager;
import io.testomat.testng.constructor.TestNgTestResultConstructor;
import io.testomat.testng.constructor.TestResultWrapper;
import io.testomat.testng.extractor.TestNgMetaDataExtractor;
import io.testomat.testng.extractor.TestNgTestWrapper;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.testng.IInvokedMethodListener;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestListener;
import org.testng.ITestResult;
import org.testng.annotations.Test;

public class TestNgListener
implements ISuiteListener,
ITestListener,
IInvokedMethodListener {
    private static final String DISABLED_MESSAGE = "Test disabled via @Test(enabled = false)";
    private final TestNgTestResultConstructor resultConstructor = new TestNgTestResultConstructor();
    private final GlobalRunManager runManager = GlobalRunManager.getInstance();
    private final Set<String> processedTests = new HashSet<String>();
    private final TestNgMetaDataExtractor metaDataExtractor = new TestNgMetaDataExtractor();

    public void onStart(ISuite suite) {
        this.runManager.incrementSuiteCounter();
        this.checkAndReportDisabledTests(suite);
    }

    public void onFinish(ISuite suite) {
        this.runManager.decrementSuiteCounter();
    }

    public void onTestSuccess(ITestResult result) {
        this.handleTestNgResult(result, "passed");
    }

    public void onTestFailure(ITestResult result) {
        this.handleTestNgResult(result, "failed");
    }

    public void onTestSkipped(ITestResult result) {
        this.handleTestNgResult(result, "skipped");
    }

    private void handleTestNgResult(ITestResult result, String status) {
        String methodKey = result.getTestClass().getName() + "." + result.getMethod().getMethodName();
        if (this.processedTests.contains(methodKey)) {
            return;
        }
        this.processedTests.add(methodKey);
        TestNgTestWrapper wrapper = TestNgTestWrapper.forRegularTest(result);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.reportTestResult(metadata, status, null, result);
    }

    private void checkAndReportDisabledTests(ISuite suite) {
        if (!this.runManager.isActive()) {
            return;
        }
        suite.getXmlSuite().getTests().forEach(xmlTest -> xmlTest.getXmlClasses().forEach(xmlClass -> {
            try {
                Method[] methods;
                Class<?> testClass = Class.forName(xmlClass.getName());
                for (Method method : methods = testClass.getDeclaredMethods()) {
                    String methodKey;
                    Test testAnnotation = method.getAnnotation(Test.class);
                    if (testAnnotation == null || testAnnotation.enabled() || this.processedTests.contains(methodKey = xmlClass.getName() + "." + method.getName())) continue;
                    this.processedTests.add(methodKey);
                    this.reportDisabledTest(method, testClass);
                }
            }
            catch (ClassNotFoundException e) {
                throw new TestClassNotFoundException("Failed to load test class: " + xmlClass.getName(), e);
            }
        }));
    }

    private void reportDisabledTest(Method method, Class<?> testClass) {
        TestNgTestWrapper wrapper = TestNgTestWrapper.forDisabledTest(method, testClass);
        TestMetadata metadata = this.metaDataExtractor.extractTestMetadata(wrapper);
        this.reportTestResult(metadata, "skipped", DISABLED_MESSAGE, null);
    }

    private void reportTestResult(TestMetadata metadata, String status, String message, Object frameworkSpecificData) {
        if (!this.runManager.isActive()) {
            return;
        }
        try {
            TestResultWrapper.Builder builder = TestResultWrapper.builder().withTestMetadata(metadata).withStatus(status);
            if (message != null) {
                builder.withMessage(message);
            }
            if (frameworkSpecificData instanceof ITestResult) {
                builder.withTestResult((ITestResult)frameworkSpecificData);
            }
            TestResultWrapper wrapper = builder.build();
            TestResult result = this.resultConstructor.constructTestRunResult(wrapper);
            this.runManager.reportTest(result);
        }
        catch (Exception e) {
            String testName = metadata != null ? metadata.getTitle() : "Unknown Test";
            throw new ReportTestResultException("Failed to report test result for: " + testName, e);
        }
    }
}

