/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.testng.extractor;

import java.lang.reflect.Method;
import org.testng.ITestResult;

public class TestNgTestWrapper {
    private final ITestResult testResult;
    private final Method method;
    private final Class<?> testClass;
    private final TestType testType;

    public TestNgTestWrapper(ITestResult testResult) {
        this.testResult = testResult;
        this.method = null;
        this.testClass = null;
        this.testType = TestType.REGULAR_TEST;
    }

    public TestNgTestWrapper(Method method, Class<?> testClass) {
        this.testResult = null;
        this.method = method;
        this.testClass = testClass;
        this.testType = TestType.DISABLED_TEST;
    }

    public ITestResult getTestResult() {
        return this.testResult;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public boolean isRegularTest() {
        return this.testType == TestType.REGULAR_TEST;
    }

    public String toString() {
        if (this.isRegularTest()) {
            assert (this.testResult != null);
            return String.format("TestNGTestWrapper{type=REGULAR_TEST, testClass=%s, method=%s}", this.testResult.getTestClass().getName(), this.testResult.getMethod().getMethodName());
        }
        assert (this.testClass != null);
        assert (this.method != null);
        return String.format("TestNGTestWrapper{type=DISABLED_TEST, testClass=%s, method=%s}", this.testClass.getSimpleName(), this.method.getName());
    }

    public static TestNgTestWrapper forRegularTest(ITestResult testResult) {
        return new TestNgTestWrapper(testResult);
    }

    public static TestNgTestWrapper forDisabledTest(Method method, Class<?> testClass) {
        return new TestNgTestWrapper(method, testClass);
    }

    public static enum TestType {
        REGULAR_TEST,
        DISABLED_TEST;

    }
}

