/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.testng.constructor;

import io.testomat.core.model.ExceptionDetails;
import io.testomat.core.model.TestMetadata;
import io.testomat.core.model.TestResult;
import io.testomat.testng.constructor.TestResultWrapper;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.testng.ITestResult;

public class TestNgTestResultConstructor {
    public TestResult constructTestRunResult(TestResultWrapper wrapper) {
        String stack;
        String message;
        this.validateWrapper(wrapper);
        if (wrapper.getReason() != null || wrapper.getMessage() != null) {
            message = Optional.ofNullable(wrapper.getReason()).orElse(wrapper.getMessage());
            stack = null;
        } else {
            ExceptionDetails details = this.extractExceptionDetails(wrapper);
            message = details.getMessage();
            stack = details.getStack();
        }
        return this.buildTestResult(wrapper, message, stack);
    }

    private void validateWrapper(TestResultWrapper wrapper) {
        if (wrapper == null) {
            throw new IllegalArgumentException("TestRunResultWrapper cannot be null");
        }
        if (wrapper.getTestMetadata() == null) {
            throw new IllegalArgumentException("TestMetadata cannot be null");
        }
    }

    private TestResult buildTestResult(TestResultWrapper wrapper, String message, String stack) {
        TestMetadata metadata = wrapper.getTestMetadata();
        return TestResult.builder().withTitle(metadata.getTitle()).withTestId(metadata.getTestId()).withSuiteTitle(metadata.getSuiteTitle()).withFile(metadata.getFile()).withStatus(wrapper.getStatus()).withMessage(message).withStack(stack).build();
    }

    private ExceptionDetails extractExceptionDetails(TestResultWrapper wrapper) {
        return Optional.ofNullable(wrapper.getTestResult()).map(ITestResult::getThrowable).map(this::createExceptionDetails).orElse(ExceptionDetails.empty());
    }

    private ExceptionDetails createExceptionDetails(Throwable throwable) {
        String message = throwable.getMessage();
        String stack = this.getStackTrace(throwable);
        return new ExceptionDetails(message, stack);
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        return sw.toString();
    }
}

