/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.propertyconfig.provider;

import io.testomat.core.exception.NoPropertyFileException;
import io.testomat.core.exception.PropertyNotFoundException;
import io.testomat.core.propertyconfig.interf.AbstractPropertyProvider;
import io.testomat.core.propertyconfig.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class FilePropertyProvider
extends AbstractPropertyProvider {
    @Override
    public String getProperty(String key) {
        String formatedKey;
        Properties properties = this.loadProperties();
        String value = properties.getProperty(formatedKey = StringUtils.fromEnvStyle(key));
        if (!StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        if (this.next != null) {
            return this.next.getProperty(key);
        }
        throw new PropertyNotFoundException("No such property: " + key);
    }

    private Properties loadProperties() {
        Properties properties = new Properties();
        try (InputStream input = this.getClass().getClassLoader().getResourceAsStream("testomatio.properties");){
            if (input != null) {
                properties.load(input);
            }
        }
        catch (IOException e) {
            throw new NoPropertyFileException("Error loading properties file: " + e.getMessage());
        }
        return properties;
    }
}

