/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.client;

import io.testomat.core.client.ApiInterface;
import io.testomat.core.client.http.CustomHttpClient;
import io.testomat.core.client.request.NativeRequestBodyBuilder;
import io.testomat.core.client.request.RequestBodyBuilder;
import io.testomat.core.client.urlbuilder.NativeUrlBuilder;
import io.testomat.core.client.urlbuilder.UrlBuilder;
import io.testomat.core.exception.FinishReportFailedException;
import io.testomat.core.exception.ReportingFailedException;
import io.testomat.core.exception.RunCreationFailedException;
import io.testomat.core.model.TestResult;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeApiClient
implements ApiInterface {
    private static final Logger log = LoggerFactory.getLogger(NativeApiClient.class);
    private final UrlBuilder urlBuilder = new NativeUrlBuilder();
    private final String apiKey;
    private final CustomHttpClient client;
    private final RequestBodyBuilder requestBodyBuilder;

    public NativeApiClient(String apiKey, CustomHttpClient client, NativeRequestBodyBuilder requestBodyBuilder) {
        this.apiKey = apiKey;
        this.client = client;
        this.requestBodyBuilder = requestBodyBuilder;
    }

    @Override
    public String createRun(String title) throws IOException {
        log.debug("Creating run with title: {}", (Object)title);
        String url = this.urlBuilder.buildCreateRunUrl();
        log.debug("Creating run with request url: {}", (Object)url);
        String requestBody = this.requestBodyBuilder.buildCreateRunBody(title);
        Map responseBody = this.client.post(url, requestBody, Map.class);
        log.debug(responseBody.toString());
        if (responseBody == null || !responseBody.containsKey("uid")) {
            throw new RunCreationFailedException("Invalid response: missing UID in create test run response");
        }
        this.logAndPrintUrls(responseBody);
        log.debug("Created test run with UID: {}", responseBody.get("uid"));
        return (String)responseBody.get("uid");
    }

    @Override
    public void reportTest(String uid, TestResult result) {
        try {
            log.debug("Reporting test result for testId: {}", (Object)result.getTestId());
            String url = this.urlBuilder.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildSingleTestReportBody(result);
            log.debug("Request body: {}", (Object)requestBody);
            this.client.post(url, requestBody, null);
        }
        catch (Exception e) {
            throw new ReportingFailedException("Failed to report test /n" + e.getMessage());
        }
    }

    @Override
    public void reportTests(String uid, List<TestResult> results) {
        try {
            if (results == null || results.isEmpty()) {
                log.debug("No test results to report");
                return;
            }
            log.debug("Reporting batch of %d test results" + results.size());
            String url = this.urlBuilder.buildReportTestUrl(uid);
            String requestBody = this.requestBodyBuilder.buildBatchTestReportBody(results, this.apiKey);
            this.client.post(url, requestBody, null);
        }
        catch (Exception e) {
            log.error("Failed to report batch test /n" + e.getMessage());
            throw new ReportingFailedException("Failed to report batch /n" + e.getMessage());
        }
    }

    @Override
    public void finishTestRun(String uid, float duration) {
        try {
            log.debug("Finishing test run with uid: {}", (Object)uid);
            String url = this.urlBuilder.buildFinishTestRunUrl(uid);
            String requestBody = this.requestBodyBuilder.buildFinishRunBody(duration);
            this.client.put(url, requestBody, null);
        }
        catch (Exception e) {
            log.error("Failed to finish test run with uid: {}", (Object)uid);
            throw new FinishReportFailedException("Failed to finish test run " + e.getMessage());
        }
    }

    private void logAndPrintUrls(Map<String, String> responseBody) {
        String publicUrl = responseBody.get("public_url");
        log.info("[TESTOMATIO] Testomat.io java core reporter version: [{}]", (Object)"0.6.3");
        System.out.println(String.format("[TESTOMATIO] Testomat.io java core reporter version: [%s]", "0.6.3"));
        if (publicUrl != null) {
            System.out.println(String.format("[TESTOMATIO] Public url: %s", publicUrl));
            log.info("[TESTOMATIO] Public url: {}", (Object)publicUrl);
        }
        log.info("[TESTOMATIO] See run aggregation at: {}", (Object)responseBody.get("url"));
        System.out.println(String.format("[TESTOMATIO] See run aggregation at: %s", responseBody.get("url")));
    }
}

