/*
 * Decompiled with CFR 0.152.
 */
package io.testomat.core.batch;

import io.testomat.core.client.ApiInterface;
import io.testomat.core.model.TestResult;
import io.testomat.core.propertyconfig.impl.PropertyProviderFactoryImpl;
import io.testomat.core.propertyconfig.interf.PropertyProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchResultManager {
    private static final Logger log = LoggerFactory.getLogger(BatchResultManager.class);
    private static final int MAX_RETRY_ATTEMPTS = 3;
    private static final int TERMINATION_AWAIT_TIMEOUT_SECONDS = 10;
    private final List<TestResult> pendingResults = new ArrayList<TestResult>();
    private final List<TestResult> failedResults = new ArrayList<TestResult>();
    private final int batchSize;
    private final ApiInterface apiClient;
    private final String runUid;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean isActive = new AtomicBoolean(true);

    public BatchResultManager(ApiInterface apiClient, String runUid) {
        this.apiClient = apiClient;
        this.runUid = runUid;
        PropertyProvider propertyProvider = PropertyProviderFactoryImpl.getPropertyProviderFactory().getPropertyProvider();
        this.batchSize = Integer.parseInt(propertyProvider.getProperty("testomatio.batch.size") != null ? propertyProvider.getProperty("testomatio.batch.size") : String.valueOf(10));
        int flushInterval = Integer.parseInt(propertyProvider.getProperty("testomatio.batch.flush.interval") != null ? propertyProvider.getProperty("testomatio.batch.flush.interval") : String.valueOf(10));
        this.scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "TestomatBatchFlush");
            t.setDaemon(true);
            return t;
        });
        this.scheduler.scheduleAtFixedRate(this::flushPendingResults, flushInterval, flushInterval, TimeUnit.SECONDS);
        log.debug("BatchResultManager initialized: batchSize= {}, flushInterval= {} sec", (Object)this.batchSize, (Object)flushInterval);
    }

    public synchronized void addResult(TestResult result) {
        if (!this.isActive.get()) {
            log.warn("BatchResultManager is not active, skipping result: {}", (Object)result.getTitle());
            return;
        }
        this.pendingResults.add(result);
        log.debug("Added test result: {} (pending: {})", (Object)result.getTitle(), (Object)this.pendingResults.size());
        if (this.pendingResults.size() >= this.batchSize) {
            this.flushPendingResults();
        }
    }

    public synchronized void flushPendingResults() {
        if (this.pendingResults.isEmpty()) {
            return;
        }
        ArrayList<TestResult> toSend = new ArrayList<TestResult>(this.pendingResults);
        this.pendingResults.clear();
        this.sendBatch(toSend, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch(List<TestResult> results, int attempt) {
        try {
            if (results.size() == 1) {
                this.apiClient.reportTest(this.runUid, results.get(0));
                log.debug("Reported single test: {}", (Object)results.get(0).getTitle());
            } else {
                this.apiClient.reportTests(this.runUid, results);
                log.debug("Reported batch of %d tests{}", (Object)results.size());
            }
        }
        catch (IOException e) {
            log.error("Failed to report batch (attempt {}/{}): {}", new Object[]{attempt, 3, e.getMessage()});
            if (attempt < 3) {
                this.scheduler.schedule(() -> this.sendBatch(results, attempt + 1), (long)Math.pow(2.0, attempt), TimeUnit.SECONDS);
            }
            BatchResultManager batchResultManager = this;
            synchronized (batchResultManager) {
                this.failedResults.addAll(results);
            }
            log.error("Failed to report {} tests after {} attempts", (Object)results.size(), (Object)3);
        }
    }

    public synchronized void shutdown() {
        this.isActive.set(false);
        this.flushPendingResults();
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.scheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
        if (!this.failedResults.isEmpty()) {
            log.warn("BatchResultManager shutdown with {} failed results", (Object)this.failedResults.size());
        }
        log.debug("BatchResultManager shutdown completed");
    }
}

