/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.model.workflow.entity;

import io.tesler.api.data.dictionary.LOV;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTransitionHistory;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="WAITING_REMOTE_SYSTEM", uniqueConstraints={@UniqueConstraint(columnNames={"CORRELATION_ID", "REQ_POST_FUN_CD"})})
public class WaitingRemoteSystem
extends BaseEntity {
    @ManyToOne
    @JoinColumn(name="PARENT_WAITING_ID")
    private WaitingRemoteSystem parentWaiting;
    @Column(name="CORRELATION_ID", nullable=false)
    private String correlationId;
    @ManyToOne
    @JoinColumn(name="WF_TASK_ID", nullable=false)
    private WorkflowTask workflowTask;
    @ManyToOne
    @JoinColumn(name="REQ_POST_FUN_ID", nullable=false)
    private WorkflowPostFunction postFunction;
    @Column(name="REQ_POST_FUN_CD", nullable=false)
    private LOV postFunctionCd;
    @Column(name="STATUS_CD")
    private LOV statusCd;
    @ManyToOne
    @JoinColumn(name="RESP_STEP_ID")
    private WorkflowStep responseStep;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="RESP_TRANSITION_HIST_ID")
    private WorkflowTransitionHistory transitionHistory;
    @OneToMany(fetch=FetchType.LAZY, mappedBy="parentWaiting")
    private List<WaitingRemoteSystem> childWaiting;

    public WaitingRemoteSystem getParentWaiting() {
        return this.parentWaiting;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public WorkflowTask getWorkflowTask() {
        return this.workflowTask;
    }

    public WorkflowPostFunction getPostFunction() {
        return this.postFunction;
    }

    public LOV getPostFunctionCd() {
        return this.postFunctionCd;
    }

    public LOV getStatusCd() {
        return this.statusCd;
    }

    public WorkflowStep getResponseStep() {
        return this.responseStep;
    }

    public WorkflowTransitionHistory getTransitionHistory() {
        return this.transitionHistory;
    }

    public List<WaitingRemoteSystem> getChildWaiting() {
        return this.childWaiting;
    }

    public void setParentWaiting(WaitingRemoteSystem parentWaiting) {
        this.parentWaiting = parentWaiting;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public void setWorkflowTask(WorkflowTask workflowTask) {
        this.workflowTask = workflowTask;
    }

    public void setPostFunction(WorkflowPostFunction postFunction) {
        this.postFunction = postFunction;
    }

    public void setPostFunctionCd(LOV postFunctionCd) {
        this.postFunctionCd = postFunctionCd;
    }

    public void setStatusCd(LOV statusCd) {
        this.statusCd = statusCd;
    }

    public void setResponseStep(WorkflowStep responseStep) {
        this.responseStep = responseStep;
    }

    public void setTransitionHistory(WorkflowTransitionHistory transitionHistory) {
        this.transitionHistory = transitionHistory;
    }

    public void setChildWaiting(List<WaitingRemoteSystem> childWaiting) {
        this.childWaiting = childWaiting;
    }
}

