/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.services.ConditionCheck;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
final class TransitionCheck {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TransitionCheck.class);
    private final ConditionCheck conditionCheck;
    private final WorkflowSettings<?> workflowSettings;
    private final WorkflowDaoImpl workflowDao;

    boolean isAvailable(WorkflowableTask task, WorkflowTransition transition) {
        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {} \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", new Object[]{transition.getName(), transition.getId(), task.getId()});
        List<WorkflowTransitionConditionGroup> conditionGroups = this.workflowDao.getTransitionConditionGroups(transition, WorkflowDictionaries.ConditionGroupType.CONDITION);
        if (conditionGroups.isEmpty()) {
            log.debug("\u0421\u043f\u0438\u0441\u043e\u043a \u0433\u0440\u0443\u043f\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043f\u0443\u0441\u0442, \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
            return true;
        }
        for (WorkflowTransitionConditionGroup conditionGroup : conditionGroups) {
            log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0433\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {}", (Object)conditionGroup.getName(), (Object)conditionGroup.getId());
            List conditions = this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), conditionGroup);
            if (!this.conditionCheck.isAvailable(task, conditions, transition)) continue;
            log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
            return true;
        }
        log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d");
        return false;
    }

    @Generated
    public TransitionCheck(ConditionCheck conditionCheck, WorkflowSettings<?> workflowSettings, WorkflowDaoImpl workflowDao) {
        this.conditionCheck = conditionCheck;
        this.workflowSettings = workflowSettings;
        this.workflowDao = workflowDao;
    }
}

