/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.dao;

import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.DictionaryType;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.engine.workflow.cache.WorkflowCache;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.core.dao.util.JpaUtils;
import io.tesler.model.core.entity.AbstractEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.core.entity.Project;
import io.tesler.model.core.entity.User;
import io.tesler.model.workflow.entity.PendingTransition;
import io.tesler.model.workflow.entity.Workflow;
import io.tesler.model.workflow.entity.WorkflowAssigneeRecommendation;
import io.tesler.model.workflow.entity.WorkflowAssigneeRecommendation_;
import io.tesler.model.workflow.entity.WorkflowCondition;
import io.tesler.model.workflow.entity.WorkflowCondition_;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowPostFunction_;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup_;
import io.tesler.model.workflow.entity.WorkflowStepField;
import io.tesler.model.workflow.entity.WorkflowStep_;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionHistory;
import io.tesler.model.workflow.entity.WorkflowTransitionHistory_;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation_;
import io.tesler.model.workflow.entity.WorkflowTransition_;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowVersion_;
import io.tesler.model.workflow.entity.Workflow_;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import lombok.Generated;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@Extension
public class WorkflowDaoImpl
implements WorkflowDao {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowDaoImpl.class);
    @PersistenceContext(unitName="teslerEntityManagerFactory")
    private EntityManager entityManager;
    @Autowired
    private JpaDao jpaDao;
    @Autowired
    private WorkflowCache workflowCache;

    public WorkflowStep getCurrentStep(WorkflowableTask task) {
        WorkflowTask workflowTask = task.getWorkflowTask();
        if (workflowTask != null) {
            return workflowTask.getWorkflowStep();
        }
        return this.getInitialStep(task.getProject(), task.getTaskType());
    }

    public WorkflowStep getHiddenStep(WorkflowVersion version) {
        return (WorkflowStep)this.jpaDao.getFirstResultOrNull(WorkflowStep.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowStep_.linkedStatusCd), (Object)CoreDictionaries.TaskStatus.HIDDEN), (Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion), (Object)version)));
    }

    public WorkflowStep getInitialStep(Project project, LOV taskType) {
        Workflow workflow = (Workflow)this.jpaDao.getSingleResultOrNull(Workflow.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(Workflow_.project), (Object)project), (Expression)cb.equal((Expression)root.get(Workflow_.taskTypeCd), (Object)taskType)));
        return workflow == null || workflow.getActiveVersion() == null ? null : workflow.getActiveVersion().getFirstStep();
    }

    public boolean isInitialStep(WorkflowStep workflowStep) {
        return workflowStep == null || Objects.equals(this.workflowCache.getFirstWorkflowStep(workflowStep), workflowStep);
    }

    public WorkflowStep getStepByName(WorkflowVersion version, String name) {
        return (WorkflowStep)this.jpaDao.getSingleResultOrNull(WorkflowStep.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowStep_.workflowVersion), (Object)version), (Expression)cb.equal((Expression)root.get(WorkflowStep_.name), (Object)name)));
    }

    public List<WorkflowTransition> getTransitionsByName(Workflow workflow, String name) {
        return this.jpaDao.getList(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow), (Object)workflow), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.name), (Object)name)));
    }

    public WorkflowTransition getTransitionByName(WorkflowVersion version, String name) {
        return (WorkflowTransition)this.jpaDao.getSingleResultOrNull(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion), (Object)version), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.name), (Object)name)));
    }

    public WorkflowTransition getLastWorkflowTransitionByName(String name) {
        return (WorkflowTransition)this.jpaDao.getSingleResultOrNull(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> {
            Subquery subquery = query.subquery(Double.class);
            Root subqueryRoot = subquery.from(WorkflowTransition.class);
            subquery.select(cb.max((Expression)subqueryRoot.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.version)));
            subquery.where((Expression)cb.and((Expression)cb.equal((Expression)subqueryRoot.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.draft), (Object)Boolean.FALSE), (Expression)cb.equal((Expression)subqueryRoot.get(WorkflowTransition_.name), (Object)name)));
            return cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.version), (Expression)subquery), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.name), (Object)name));
        });
    }

    public WorkflowTransition getActiveWorkflowTransitionByName(String name) {
        return this.jpaDao.getList(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.name), (Object)name), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.id), (Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow).get(Workflow_.activeVersion).get(WorkflowVersion_.id)))).stream().findFirst().orElse(null);
    }

    public WorkflowTransition getTransition(LOV taskType, LOV sourceStepTaskStatus, LOV destinationStepTaskStatus) {
        return (WorkflowTransition)this.jpaDao.getFirstResultOrNull(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.linkedStatusCd), (Object)sourceStepTaskStatus), cb.equal((Expression)root.get(WorkflowTransition_.destinationStep).get(WorkflowStep_.linkedStatusCd), (Object)destinationStepTaskStatus), cb.equal((Expression)root.get(WorkflowTransition_.sourceStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow).get(Workflow_.taskTypeCd), (Object)taskType), cb.equal((Expression)root.get(WorkflowTransition_.destinationStep).get(WorkflowStep_.workflowVersion).get(WorkflowVersion_.workflow).get(Workflow_.taskTypeCd), (Object)taskType)}));
    }

    public WorkflowTransitionHistory getLastTransitionHistoryByDestinationStep(WorkflowTask task, WorkflowStep destinationStep) {
        return (WorkflowTransitionHistory)this.jpaDao.getFirstResultOrNull(WorkflowTransitionHistory.class, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.desc((Expression)root.get(BaseEntity_.createdDate))});
            return cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransitionHistory_.workflowTask), (Object)task), (Expression)cb.equal((Expression)root.get(WorkflowTransitionHistory_.transition).get(WorkflowTransition_.destinationStep), (Object)destinationStep));
        });
    }

    public WorkflowTransitionHistory getLastTransitionHistory(WorkflowTask task) {
        return (WorkflowTransitionHistory)this.jpaDao.getFirstResultOrNull(WorkflowTransitionHistory.class, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.desc((Expression)root.get(BaseEntity_.createdDate))});
            return cb.equal((Expression)root.get(WorkflowTransitionHistory_.workflowTask), (Object)task);
        });
    }

    public void createDefaultPostFunctions(WorkflowTransitionConditionGroup transitionConditionGroup) {
        WorkflowPostFunction postFunction = new WorkflowPostFunction();
        postFunction.setConditionGroup(transitionConditionGroup);
        postFunction.setSeq(Long.valueOf(1L));
        postFunction.setActionCd(CoreDictionaries.WfPostFunction.SET_STEP_TERM);
        postFunction.setStepTerm(Long.valueOf(0L));
        this.jpaDao.save((Object)postFunction);
    }

    public void deletePostFunction(WorkflowPostFunction postFunction) {
        this.jpaDao.delete((AbstractEntity)postFunction);
    }

    public void deleteTransitionConditionGroup(WorkflowTransitionConditionGroup transitionConditionGroup) {
        this.deleteRelations(transitionConditionGroup);
        this.jpaDao.delete((AbstractEntity)transitionConditionGroup);
    }

    public WorkflowVersion getWorkflowVersion(WorkflowableTask task) {
        WorkflowStep currentStep = this.getCurrentStep(task);
        return currentStep == null ? null : currentStep.getWorkflowVersion();
    }

    public List<LOV> getTaskTypesNotInWf(Project project) {
        return JpaUtils.selectNativeQuery((EntityManager)this.entityManager, (String)"select d.key from dictionary_item d where d.type = ? and d.key not in (select w.task_type_cd from wf w where w.project_id = ?)", (Object[])new Object[]{DictionaryType.TASK_TYPE.getName(), project}).stream().map(arg_0 -> ((DictionaryType)DictionaryType.TASK_TYPE).lookupName(arg_0)).collect(Collectors.toList());
    }

    public BigDecimal getMaxVersion(Workflow workflow) {
        WorkflowVersion version = (WorkflowVersion)this.jpaDao.getFirstResultOrNull(WorkflowVersion.class, (Specification & Serializable)(root, query, cb) -> {
            query.orderBy(new Order[]{cb.desc((Expression)root.get(WorkflowVersion_.version))});
            return cb.equal((Expression)root.get(WorkflowVersion_.workflow), (Object)workflow);
        });
        return version == null || version.getVersion() == null ? BigDecimal.ZERO : BigDecimal.valueOf(version.getVersion());
    }

    public BigDecimal getNextVersion(Workflow workflow, boolean majorVersion) {
        BigDecimal bigDecimal = this.getMaxVersion(workflow);
        return majorVersion ? bigDecimal.setScale(0, RoundingMode.DOWN).add(BigDecimal.ONE) : bigDecimal.add(BigDecimal.valueOf(0.001));
    }

    public PendingTransition createPendingTransition(WorkflowTransition transition, User sessionUser, LOV sessionUserRole) {
        PendingTransition pendingTransition = new PendingTransition();
        pendingTransition.setTransition(transition);
        pendingTransition.setUser(sessionUser);
        pendingTransition.setUserRole(sessionUserRole);
        this.jpaDao.save((Object)pendingTransition);
        return pendingTransition;
    }

    public WorkflowTask createWorkflowTask(WorkflowStep step) {
        if (step == null) {
            return null;
        }
        WorkflowTask workflowTask = new WorkflowTask();
        workflowTask.setWorkflowStep(step);
        this.jpaDao.save((Object)workflowTask);
        return workflowTask;
    }

    public List<WorkflowStepConditionGroup> getStepConditionGroups(WorkflowStep step) {
        List result = this.jpaDao.getList(WorkflowStepConditionGroup.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowStepConditionGroup_.step), (Object)step));
        result.sort(Comparator.comparing(WorkflowStepConditionGroup::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    public List<WorkflowAssigneeRecommendation> getAssigneeRecommendations(WorkflowStepConditionGroup condGroup) {
        return this.jpaDao.getList(WorkflowAssigneeRecommendation.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowAssigneeRecommendation_.conditionGroup), (Object)condGroup));
    }

    public List<WorkflowTransitionConditionGroup> getTransitionConditionGroups(WorkflowTransition transition, LOV condGroupCd) {
        return this.workflowCache.getTransitionConditionGroups(transition, condGroupCd);
    }

    public <V extends WorkflowTransitionValidation> List<V> getValidations(Class<V> transitionValidationClass, WorkflowTransitionConditionGroup conditionGroup) {
        List result = this.jpaDao.getList(transitionValidationClass, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowTransitionValidation_.conditionGroup), (Object)conditionGroup));
        result.sort(Comparator.comparing(WorkflowTransitionValidation::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    public <P extends WorkflowPostFunction> List<P> getPostFunctions(Class<P> postFunctionClass, WorkflowTransitionConditionGroup conditionGroup) {
        List result = this.jpaDao.getList(postFunctionClass, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup), (Object)conditionGroup));
        result.sort(Comparator.comparing(WorkflowPostFunction::getSeq, Comparator.nullsLast(Comparator.naturalOrder())));
        return result;
    }

    public WorkflowTransition getTransition(Long transitionId) {
        return (WorkflowTransition)this.jpaDao.getSingleResultOrNull(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(BaseEntity_.id), (Object)transitionId));
    }

    public List<WorkflowStepField> getStepFields(WorkflowStep sourceStep) {
        if (sourceStep == null) {
            return Collections.emptyList();
        }
        return this.workflowCache.getStepFields(sourceStep);
    }

    public List<WorkflowTransition> getTransitions(WorkflowStep sourceStep) {
        if (sourceStep == null) {
            return Collections.emptyList();
        }
        return this.workflowCache.getTransitions(sourceStep);
    }

    public List<WorkflowTaskChildBcAvailability> getWorkflowTaskChildBcAvailabilities(WorkflowStep workflowStep) {
        if (workflowStep == null) {
            return Collections.emptyList();
        }
        return this.workflowCache.getWorkflowTaskChildBcAvailabilities(workflowStep);
    }

    public WorkflowTransition getTransitionBetweenSteps(WorkflowStep sourceStep, WorkflowStep destinationStep) {
        return (WorkflowTransition)this.jpaDao.getSingleResultOrNull(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep), (Object)sourceStep), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.destinationStep), (Object)destinationStep)));
    }

    public WorkflowTransitionHistory saveTransitionHistory(WorkflowableTask task, WorkflowTransition transition, User currentUser, User previousAssignee) {
        WorkflowTransitionHistory history = new WorkflowTransitionHistory();
        history.setWorkflowTask(task.getWorkflowTask());
        history.setTransition(transition);
        history.setTransitionUser(currentUser);
        history.setPreviousAssignee(previousAssignee);
        this.jpaDao.save((Object)history);
        return history;
    }

    public <C extends WorkflowCondition> List<C> getConditions(Class<C> conditionClass, WorkflowTransitionConditionGroup conditionGroup) {
        return this.workflowCache.getTransitionConditions(conditionClass, conditionGroup);
    }

    public <C extends WorkflowCondition> List<C> getConditions(Class<C> conditionClass, WorkflowStepConditionGroup conditionGroup) {
        return this.workflowCache.getStepConditions(conditionClass, conditionGroup);
    }

    public <C extends WorkflowCondition> List<C> getConditions(Class<C> conditionClass, WorkflowStepField stepField) {
        return this.workflowCache.getFieldConditions(conditionClass, stepField);
    }

    public <C extends WorkflowCondition> List<C> getConditions(Class<C> conditionClass, WorkflowTaskChildBcAvailability childBcAvailability) {
        return this.workflowCache.getAvailabilityConditions(conditionClass, childBcAvailability);
    }

    private void deleteRelations(WorkflowTransitionConditionGroup transitionConditionGroup) {
        int count = this.jpaDao.delete(WorkflowCondition.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowCondition_.transitionConditionGroup), (Object)transitionConditionGroup));
        if ((count += this.jpaDao.delete(WorkflowPostFunction.class, (Specification & Serializable)(root, cq, cb) -> cb.equal((Expression)root.get(WorkflowPostFunction_.conditionGroup), (Object)transitionConditionGroup))) > 0) {
            this.jpaDao.flush();
        }
    }
}

