/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.service.session.InternalAuthorizationService;
import io.tesler.api.service.tx.TransactionService;
import io.tesler.api.system.SystemSettings;
import io.tesler.api.util.Invoker;
import io.tesler.api.util.privileges.PrivilegeUtil;
import io.tesler.core.service.ScheduledService;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.engine.workflow.services.WorkflowNotificationService;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.core.entity.AbstractEntity;
import io.tesler.model.core.entity.ScheduledJob;
import io.tesler.model.workflow.entity.PendingTransition;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTask_;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Extension
@Service(value="regularExecuteBackgroundWorkflowTransition")
public class ExecuteBackgroundWorkflowTransitionService
implements ExtensionPoint,
ScheduledService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteBackgroundWorkflowTransitionService.class);
    private final WorkflowEngine workflowEngine;
    private final WorkflowableTaskDao<?> workflowableTaskDao;
    private final Optional<WorkflowNotificationService> workflowNotificationService;
    private final JpaDao jpaDao;
    private final TransactionService transactionService;
    private final InternalAuthorizationService authorizationService;
    private final ExecutorService executorService;

    public ExecuteBackgroundWorkflowTransitionService(WorkflowEngine workflowEngine, WorkflowableTaskDao<?> workflowableTaskDao, Optional<WorkflowNotificationService> workflowNotificationService, JpaDao jpaDao, TransactionService transactionService, InternalAuthorizationService authorizationService, SystemSettings systemSettings) {
        this.workflowEngine = workflowEngine;
        this.workflowableTaskDao = workflowableTaskDao;
        this.workflowNotificationService = workflowNotificationService;
        this.jpaDao = jpaDao;
        this.transactionService = transactionService;
        this.authorizationService = authorizationService;
        this.executorService = Executors.newFixedThreadPool(NumberUtils.toInt((String)systemSettings.getValue(CoreDictionaries.SystemPref.WF_BACKGROUND_TRANSITION_THREADS_COUNT), (int)1), new ThreadFactoryBuilder().setNameFormat("wfBackgroundTransition-%d").setDaemon(true).build());
    }

    @Transactional
    public void execute(ScheduledJob job) {
        this.cleanPendingTransitionTable();
        ArrayList<TransitionInvoke> callables = new ArrayList<TransitionInvoke>();
        for (WorkflowTask workflowTask : this.workflowableTaskDao.getPendingTransitionWorkflowTasks()) {
            callables.add(new TransitionInvoke(this.workflowEngine, workflowTask.getPendingTransition().getUser().getLogin(), workflowTask.getPendingTransition().getUserRole(), workflowTask.getId()));
        }
        this.executorService.invokeAll(callables);
    }

    private void cleanPendingTransitionTable() {
        this.transactionService.invokeInNewTx(Invoker.of(() -> this.jpaDao.delete(PendingTransition.class, (Specification & Serializable)(root, query, cb) -> {
            Subquery subquery = query.subquery(PendingTransition.class);
            Root subqueryRoot = subquery.from(WorkflowTask.class);
            subquery.select((Expression)subqueryRoot.get(WorkflowTask_.pendingTransition));
            subquery.where((Expression)subqueryRoot.get(WorkflowTask_.pendingTransition).isNotNull());
            return root.in(new Expression[]{subquery}).not();
        })));
    }

    private class TransitionInvoke
    implements Callable<Void> {
        private final WorkflowEngine workflowEngine;
        private final String userLogin;
        private final LOV userRole;
        private final Long workflowTaskId;

        @Override
        public Void call() {
            PrivilegeUtil.runPrivileged((Invoker)Invoker.of(() -> {
                ExecuteBackgroundWorkflowTransitionService.this.authorizationService.loginAs(this.userLogin, this.userRole);
                try {
                    ExecuteBackgroundWorkflowTransitionService.this.transactionService.invokeInNewTx(Invoker.of(() -> {
                        WorkflowTask workflowTask = (WorkflowTask)ExecuteBackgroundWorkflowTransitionService.this.jpaDao.findById(WorkflowTask.class, this.workflowTaskId);
                        ExecuteBackgroundWorkflowTransitionService.this.jpaDao.lockAndRefresh((AbstractEntity)workflowTask, -1);
                        PendingTransition pendingTransition = workflowTask.getPendingTransition();
                        if (pendingTransition != null) {
                            this.workflowEngine.forceInvokeAutoTransition(ExecuteBackgroundWorkflowTransitionService.this.workflowableTaskDao.getTask(workflowTask), pendingTransition.getTransition());
                            workflowTask.setPendingTransition(null);
                        }
                    }));
                }
                catch (Exception e) {
                    UUID uuid = UUID.randomUUID();
                    log.error(uuid.toString() + ": \u041e\u0448\u0438\u0431\u043a\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0444\u043e\u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430.", (Throwable)e);
                    try {
                        ExecuteBackgroundWorkflowTransitionService.this.transactionService.invokeInNewTx(Invoker.of(() -> {
                            WorkflowTask workflowTask = (WorkflowTask)ExecuteBackgroundWorkflowTransitionService.this.jpaDao.findById(WorkflowTask.class, this.workflowTaskId);
                            ExecuteBackgroundWorkflowTransitionService.this.jpaDao.lockAndRefresh((AbstractEntity)workflowTask, -1);
                            PendingTransition pendingTransition = workflowTask.getPendingTransition();
                            if (pendingTransition != null) {
                                ExecuteBackgroundWorkflowTransitionService.this.workflowNotificationService.ifPresent(notificationService -> notificationService.sendBackgroundTransitionErrorMessage(uuid, ExecuteBackgroundWorkflowTransitionService.this.workflowableTaskDao.getTask(workflowTask), pendingTransition.getTransition()));
                                workflowTask.setWorkflowStep(pendingTransition.getTransition().getSourceStep());
                                workflowTask.setPendingTransition(null);
                            }
                        }));
                    }
                    catch (Exception e2) {
                        log.error(uuid.toString() + ": \u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0435 \u043d\u0430 \u0438\u0441\u0445\u043e\u0434\u043d\u044b\u0439 \u0448\u0430\u0433 \u0444\u043e\u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430.", (Throwable)e2);
                    }
                }
            }));
            return null;
        }

        @Generated
        public TransitionInvoke(WorkflowEngine workflowEngine, String userLogin, LOV userRole, Long workflowTaskId) {
            this.workflowEngine = workflowEngine;
            this.userLogin = userLogin;
            this.userRole = userRole;
            this.workflowTaskId = workflowTaskId;
        }
    }
}

