/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BcIdentifiers;
import io.tesler.core.crudma.bc.BcRegistry;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.service.rowmeta.BcDisabler;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.workflow.entity.WorkflowVersion;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.pf4j.Extension;
import org.springframework.stereotype.Service;

@Extension
@Service
public class WorkflowAdministrationBcDisabler
extends BcDisabler {
    private final BcRegistry bcRegistry;
    private final JpaDao jpaDao;
    private final BcIdentifiers ignoredBcIdentifiers = BcIdentifiers.of((BcIdentifier[])new BcIdentifier[]{WorkflowServiceAssociation.wfTaskMigration, WorkflowServiceAssociation.wfTemplateMigration});

    public Collection<BcIdentifier> getSupportedBc() {
        return this.bcRegistry.select(bcDescription -> {
            String parentBcName = bcDescription.getParentName();
            while (parentBcName != null) {
                BcDescription parentBc = this.bcRegistry.getBcDescription(parentBcName);
                if (WorkflowServiceAssociation.wfVersion.isBc((BcIdentifier)parentBc)) {
                    return true;
                }
                parentBcName = parentBc.getParentName();
            }
            return false;
        }).filter(bcDescription -> !this.ignoredBcIdentifiers.contains((BcIdentifier)bcDescription)).collect(Collectors.toList());
    }

    public boolean isBcDisabled(BusinessComponent bc) {
        String wfVersionId = bc.getHierarchy().getId(WorkflowServiceAssociation.wfVersion.getName());
        String string = wfVersionId = Objects.equals(wfVersionId, "null") ? null : wfVersionId;
        if (wfVersionId == null) {
            return true;
        }
        WorkflowVersion workflowVersion = (WorkflowVersion)this.jpaDao.findById(WorkflowVersion.class, NumberUtils.createLong((String)wfVersionId));
        if (workflowVersion != null) {
            return !workflowVersion.isDraft();
        }
        return true;
    }

    protected boolean isActionDisabled(String actionName) {
        return true;
    }

    @Generated
    public WorkflowAdministrationBcDisabler(BcRegistry bcRegistry, JpaDao jpaDao) {
        this.bcRegistry = bcRegistry;
        this.jpaDao = jpaDao;
    }
}

