/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.function.DefaultPostFunction;
import io.tesler.engine.workflow.function.PostFunction;
import io.tesler.engine.workflow.services.ConditionCheck;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
final class PostFunctionExecute {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostFunctionExecute.class);
    private final WorkflowSettings<?> workflowSettings;
    private final WorkflowDaoImpl workflowDao;
    private final ConditionCheck conditionCheck;
    private final PostFunction<? extends WorkflowableTask, ? extends WorkflowPostFunction> defaultPostFunction;
    private final Map<LOV, PostFunction<? extends WorkflowableTask, ? extends WorkflowPostFunction>> postFunctions;

    PostFunctionExecute(WorkflowSettings<?> workflowSettings, WorkflowDaoImpl workflowDao, ConditionCheck conditionCheck, DefaultPostFunction defaultPostFunction, List<PostFunction<? extends WorkflowableTask, ? extends WorkflowPostFunction>> postFunctions) {
        this.workflowSettings = workflowSettings;
        this.workflowDao = workflowDao;
        this.conditionCheck = conditionCheck;
        this.defaultPostFunction = defaultPostFunction;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PostFunction<? extends WorkflowableTask, ? extends WorkflowPostFunction> postFunction : postFunctions) {
            if (postFunction.getType() == null) continue;
            builder.put((Object)postFunction.getType(), postFunction);
        }
        this.postFunctions = builder.build();
    }

    List<PostAction> execute(BcDescription bcDescription, WorkflowableTask task, WorkflowTransition transition) {
        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {} \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", new Object[]{transition.getName(), transition.getId(), task.getId()});
        ArrayList<PostAction> result = new ArrayList<PostAction>();
        List<WorkflowTransitionConditionGroup> conditionGroups = this.workflowDao.getTransitionConditionGroups(transition, WorkflowDictionaries.ConditionGroupType.POST_FUNCTION);
        if (conditionGroups.isEmpty()) {
            log.debug("\u0421\u043f\u0438\u0441\u043e\u043a \u0433\u0440\u0443\u043f\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043f\u0443\u0441\u0442, \u043f\u043e\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u0438 \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u044b");
        }
        for (WorkflowTransitionConditionGroup conditionGroup : conditionGroups) {
            log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0433\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u043e\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {}", (Object)conditionGroup.getName(), (Object)conditionGroup.getId());
            List conditions = this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), conditionGroup);
            if (!this.conditionCheck.isAvailable(task, conditions, transition)) continue;
            List postFunctions = this.workflowDao.getPostFunctions(this.workflowSettings.getPostFunctionExtensionClass(), conditionGroup);
            for (WorkflowPostFunction wfPostFunction : postFunctions) {
                log.debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u043e\u0441\u0442-\u0444\u0443\u043d\u043a\u0446\u0438\u0438 '{}'", (Object)wfPostFunction.getActionCd());
                PostFunction<? extends WorkflowableTask, ? extends WorkflowPostFunction> postFunction = this.postFunctions.getOrDefault(wfPostFunction.getActionCd(), this.defaultPostFunction);
                result.addAll(postFunction.invoke(bcDescription, task, wfPostFunction));
            }
        }
        return result;
    }
}

