/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.recommendation.AssigneeRecommendation;
import io.tesler.engine.workflow.recommendation.UnsupportedRecommendation;
import io.tesler.engine.workflow.services.ConditionCheck;
import io.tesler.model.core.entity.User;
import io.tesler.model.workflow.entity.WorkflowAssigneeRecommendation;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
final class AssigneeRecommender {
    private final WorkflowSettings<?> workflowSettings;
    private final WorkflowDaoImpl workflowDao;
    private final ConditionCheck conditionCheck;
    private final AssigneeRecommendation defaultRecommendation;
    private final Map<LOV, AssigneeRecommendation> recommendations;

    AssigneeRecommender(WorkflowSettings<?> workflowSettings, WorkflowDaoImpl workflowDao, ConditionCheck conditionCheck, UnsupportedRecommendation defaultRecommendation, List<AssigneeRecommendation> assigneeRecommendations) {
        this.workflowSettings = workflowSettings;
        this.workflowDao = workflowDao;
        this.conditionCheck = conditionCheck;
        this.defaultRecommendation = defaultRecommendation;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (AssigneeRecommendation assigneeRecommendation : assigneeRecommendations) {
            if (assigneeRecommendation.getType() == null) continue;
            builder.put((Object)assigneeRecommendation.getType(), (Object)assigneeRecommendation);
        }
        this.recommendations = builder.build();
    }

    Specification<User> recommend(WorkflowableTask task) {
        return new AssigneeRecommendationSpecification(this.workflowDao.getStepConditionGroups(this.workflowDao.getCurrentStep(task)).stream().filter(conditionGroup -> this.conditionCheck.isAvailable(task, this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), (WorkflowStepConditionGroup)conditionGroup), null)).map(this.workflowDao::getAssigneeRecommendations).map(this::recommendationsToSpecifications).filter(CollectionUtils::isNotEmpty).collect(Collectors.toList()));
    }

    private List<Specification<User>> recommendationsToSpecifications(List<WorkflowAssigneeRecommendation> assigneeRecommendations) {
        return assigneeRecommendations.stream().map(assigneeRecommendation -> this.recommendations.getOrDefault(assigneeRecommendation.getCondAssigneeCd(), this.defaultRecommendation).getSpecification(assigneeRecommendation)).collect(Collectors.toList());
    }

    private static class AssigneeRecommendationSpecification
    implements Specification<User> {
        private final List<List<Specification<User>>> specificationGroups;

        public Predicate toPredicate(Root<User> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            return cb.or((Predicate[])this.specificationGroups.stream().map(specifications -> cb.and((Predicate[])specifications.stream().map(userSpecification -> userSpecification.toPredicate(root, query, cb)).toArray(Predicate[]::new))).toArray(Predicate[]::new));
        }

        @Generated
        public AssigneeRecommendationSpecification(List<List<Specification<User>>> specificationGroups) {
            this.specificationGroups = specificationGroups;
        }
    }
}

