/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.Sets;
import io.tesler.core.bc.InnerBcTypeAware;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BcRegistry;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.crudma.bc.impl.InnerBcDescription;
import io.tesler.core.dto.rowmeta.ActionType;
import io.tesler.core.service.rowmeta.BcDisabler;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.math.NumberUtils;
import org.pf4j.Extension;
import org.springframework.stereotype.Service;

@Extension
@Service
public class WorkflowTaskChildBcDisabler
extends BcDisabler {
    private final WorkflowEngine workflowEngine;
    private final BcRegistry bcRegistry;
    private final WorkflowableTaskDao<?> workflowableTaskDao;
    private final Map<String, String> supportedBc;

    public WorkflowTaskChildBcDisabler(WorkflowEngine workflowEngine, BcRegistry bcRegistry, WorkflowableTaskDao<?> workflowableTaskDao, InnerBcTypeAware innerBcTypeAware) {
        this.workflowEngine = workflowEngine;
        this.bcRegistry = bcRegistry;
        this.workflowableTaskDao = workflowableTaskDao;
        Set taskBcNames = bcRegistry.select(InnerBcDescription.class).filter(bcDescription -> WorkflowableTask.class.isAssignableFrom(innerBcTypeAware.getTypeOfEntity(bcDescription))).map(BcDescription::getName).collect(Collectors.toSet());
        this.supportedBc = new HashMap<String, String>();
        bcRegistry.select(BcDescription.class).forEach(bcDescription -> {
            String parentTaskBc = this.getParentTaskBc(taskBcNames, (BcDescription)bcDescription);
            if (parentTaskBc != null) {
                this.supportedBc.put(bcDescription.getName(), parentTaskBc);
            }
        });
    }

    public Collection<BcIdentifier> getSupportedBc() {
        return this.supportedBc.keySet().stream().map(arg_0 -> ((BcRegistry)this.bcRegistry).getBcDescription(arg_0)).collect(Collectors.toList());
    }

    public boolean isBcDisabled(BusinessComponent bc) {
        BcDescription bcDescription = bc.getDescription();
        if (!(bcDescription instanceof InnerBcDescription)) {
            return false;
        }
        String taskIdString = bc.getHierarchy().getId(this.supportedBc.get(bc.getName()));
        Long taskId = NumberUtils.createLong((String)(Objects.equals(taskIdString, "null") ? null : taskIdString));
        if (taskId == null) {
            return false;
        }
        return this.workflowEngine.isChildBcDisabled((BcIdentifier)bcDescription, this.workflowableTaskDao.getTask(taskId));
    }

    protected boolean isActionDisabled(String actionName) {
        return Sets.newHashSet((Object[])new String[]{ActionType.CREATE.getType(), ActionType.SAVE.getType(), ActionType.DELETE.getType(), ActionType.ASSOCIATE.getType()}).contains(actionName);
    }

    private String getParentTaskBc(Set<String> taskBcNames, BcDescription bcDescription) {
        String parentName = bcDescription.getParentName();
        while (parentName != null && !taskBcNames.contains(parentName)) {
            parentName = this.bcRegistry.getBcDescription(parentName).getParentName();
        }
        return parentName;
    }
}

