/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.cache;

import io.tesler.api.data.dictionary.LOV;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.workflow.entity.WorkflowCondition;
import io.tesler.model.workflow.entity.WorkflowCondition_;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowStepConditionGroup;
import io.tesler.model.workflow.entity.WorkflowStepField;
import io.tesler.model.workflow.entity.WorkflowStepField_;
import io.tesler.model.workflow.entity.WorkflowStep_;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability_;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup_;
import io.tesler.model.workflow.entity.WorkflowTransition_;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class WorkflowCache {
    private final JpaDao jpaDao;

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #sourceStep.id}")
    public List<WorkflowTransition> getTransitions(WorkflowStep sourceStep) {
        return this.jpaDao.getList(WorkflowTransition.class, (Specification & Serializable)(root, query, cb) -> {
            root.fetch(WorkflowTransition_.destinationStep);
            return cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransition_.sourceStep), (Object)sourceStep), (Expression)cb.equal((Expression)root.get(WorkflowTransition_.destinationStep).get(WorkflowStep_.workflowVersion), (Object)sourceStep.getWorkflowVersion()));
        }).stream().distinct().map(arg_0 -> ((JpaDao)this.jpaDao).evict(arg_0)).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #transition.id, #condGroupCd}")
    public List<WorkflowTransitionConditionGroup> getTransitionConditionGroups(WorkflowTransition transition, LOV condGroupCd) {
        return this.jpaDao.getList(WorkflowTransitionConditionGroup.class, (Specification & Serializable)(root, query, cb) -> cb.and((Expression)cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.transition), (Object)transition), (Expression)cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.condGroupCd), (Object)condGroupCd))).stream().distinct().map(arg_0 -> ((JpaDao)this.jpaDao).evict(arg_0)).sorted(Comparator.comparing(WorkflowTransitionConditionGroup::getSeq, Comparator.nullsLast(Comparator.naturalOrder()))).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #workflowStep.id}")
    public List<WorkflowStepField> getStepFields(WorkflowStep workflowStep) {
        return this.jpaDao.getList(WorkflowStepField.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowStepField_.step), (Object)workflowStep)).stream().map(arg_0 -> ((JpaDao)this.jpaDao).evict(arg_0)).collect(Collectors.toList());
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #workflowStep.id}")
    public WorkflowStep getFirstWorkflowStep(WorkflowStep workflowStep) {
        return workflowStep.getWorkflowVersion().getFirstStep();
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #workflowStep.id}")
    public List<WorkflowTaskChildBcAvailability> getWorkflowTaskChildBcAvailabilities(WorkflowStep workflowStep) {
        return this.jpaDao.getList(WorkflowTaskChildBcAvailability.class, (Specification & Serializable)(root, query, cb) -> cb.equal((Expression)root.get(WorkflowTaskChildBcAvailability_.workflowStep), (Object)workflowStep));
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #conditionGroup.id}")
    public <C extends WorkflowCondition> List<C> getTransitionConditions(Class<C> conditionClass, WorkflowTransitionConditionGroup conditionGroup) {
        List result = this.jpaDao.getList(conditionClass, (Specification & Serializable)(root, query, cb) -> {
            this.jpaDao.applyGraph(root, this.jpaDao.getEntityGraph(conditionClass, "cache"));
            return cb.equal((Expression)root.get(WorkflowCondition_.transitionConditionGroup), (Object)conditionGroup);
        });
        result.sort(Comparator.comparing(WorkflowCondition::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #conditionGroup.id}")
    public <C extends WorkflowCondition> List<C> getStepConditions(Class<C> conditionClass, WorkflowStepConditionGroup conditionGroup) {
        List result = this.jpaDao.getList(conditionClass, (Specification & Serializable)(root, query, cb) -> {
            this.jpaDao.applyGraph(root, this.jpaDao.getEntityGraph(conditionClass, "cache"));
            return cb.equal((Expression)root.get(WorkflowCondition_.stepConditionGroup), (Object)conditionGroup);
        });
        result.sort(Comparator.comparing(WorkflowCondition::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #stepField.id}")
    public <C extends WorkflowCondition> List<C> getFieldConditions(Class<C> conditionClass, WorkflowStepField stepField) {
        List result = this.jpaDao.getList(conditionClass, (Specification & Serializable)(root, query, cb) -> {
            this.jpaDao.applyGraph(root, this.jpaDao.getEntityGraph(conditionClass, "cache"));
            return cb.equal((Expression)root.get(WorkflowCondition_.stepField), (Object)stepField);
        });
        result.sort(Comparator.comparing(WorkflowCondition::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    @Cacheable(cacheNames={"workflow"}, key="{#root.methodName, #childBcAvailability.id}")
    public <C extends WorkflowCondition> List<C> getAvailabilityConditions(Class<C> conditionClass, WorkflowTaskChildBcAvailability childBcAvailability) {
        List result = this.jpaDao.getList(conditionClass, (Specification & Serializable)(root, query, cb) -> {
            this.jpaDao.applyGraph(root, this.jpaDao.getEntityGraph(conditionClass, "cache"));
            return cb.equal((Expression)root.get(WorkflowCondition_.wfChildBcAvailability), (Object)childBcAvailability);
        });
        result.sort(Comparator.comparing(WorkflowCondition::getSeq, Comparator.nullsFirst(Comparator.naturalOrder())));
        return result;
    }

    public WorkflowCache(JpaDao jpaDao) {
        this.jpaDao = jpaDao;
    }
}

