/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.engine.workflow.condition.ConditionChecker;
import io.tesler.engine.workflow.condition.UnsupportedConditionChecker;
import io.tesler.model.workflow.entity.WorkflowCondition;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class ConditionCheck {
    private static final Logger log = LoggerFactory.getLogger(ConditionCheck.class);
    private final ConditionChecker<? extends WorkflowableTask, ? extends WorkflowCondition> defaultConditionChecker;
    private final Map<LOV, ConditionChecker<? extends WorkflowableTask, ? extends WorkflowCondition>> conditionCheckers;

    ConditionCheck(UnsupportedConditionChecker defaultConditionChecker, List<ConditionChecker<? extends WorkflowableTask, ? extends WorkflowCondition>> conditionCheckers) {
        this.defaultConditionChecker = defaultConditionChecker;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ConditionChecker<? extends WorkflowableTask, ? extends WorkflowCondition> conditionChecker : conditionCheckers) {
            if (conditionChecker.getType() == null) continue;
            builder.put((Object)conditionChecker.getType(), conditionChecker);
        }
        this.conditionCheckers = builder.build();
    }

    boolean isAvailable(WorkflowableTask task, Collection<? extends WorkflowCondition> conditions, WorkflowTransition transition) {
        for (WorkflowCondition workflowCondition : conditions) {
            ConditionChecker<? extends WorkflowableTask, ? extends WorkflowCondition> conditionChecker = this.conditionCheckers.getOrDefault(workflowCondition.getCondCd(), this.defaultConditionChecker);
            if (!conditionChecker.check(task, workflowCondition, transition)) {
                log.debug("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 {} id: {} \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", (Object)workflowCondition.getCondCd().getKey(), (Object)workflowCondition.getId());
                return false;
            }
            log.debug("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 {} id: {} \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", (Object)workflowCondition.getCondCd().getKey(), (Object)workflowCondition.getId());
        }
        return true;
    }
}

