/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.notification.impl;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dao.databaselistener.IChangeVector;
import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.util.session.SessionService;
import io.tesler.engine.notification.IWorkflowVersionEventGenerator;
import io.tesler.model.core.api.notifications.INotificationEventBuilder;
import io.tesler.model.core.api.notifications.IRecipientResolver;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.User;
import io.tesler.model.core.listeners.hbn.change.notifications.AbstractEventGenerator;
import io.tesler.model.workflow.entity.WorkflowVersion;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Extension
public class WorkflowVersionEventGenerator
extends AbstractEventGenerator<WorkflowVersion>
implements IWorkflowVersionEventGenerator {
    private static final Logger log = LoggerFactory.getLogger(WorkflowVersionEventGenerator.class);
    @Autowired
    private SessionService sessionService;
    private Map<LOV, IRecipientResolver<WorkflowVersion>> recipientResolvers = new ImmutableMap.Builder().put((Object)CoreDictionaries.NotificationRecipient.CURRENT_USER, this::getCurrentUser).build();

    public Class<? extends WorkflowVersion> getType() {
        return WorkflowVersion.class;
    }

    public void process(IChangeVector vector, LOV event) {
        throw new UnsupportedOperationException();
    }

    public boolean canProcess(IChangeVector vector, LOV event) {
        return false;
    }

    public List<User> getCurrentUser(WorkflowVersion WorkflowVersion2, LOV event) {
        return Collections.singletonList(this.sessionService.getSessionUser());
    }

    public INotificationEventBuilder builder(WorkflowVersion WorkflowVersion2, LOV event) {
        return new AbstractEventGenerator.DefaultBuilder((AbstractEventGenerator)this, (BaseEntity)WorkflowVersion2, event);
    }

    public Map<LOV, IRecipientResolver<WorkflowVersion>> getRecipientResolvers() {
        return this.recipientResolvers;
    }
}

