/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.util.DateTimeUtil;
import io.tesler.core.util.session.SessionService;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.ObserverService;
import io.tesler.engine.workflow.services.PostFunctionExecute;
import io.tesler.engine.workflow.services.StatusCategoryService;
import io.tesler.engine.workflow.services.TransitionResult;
import io.tesler.model.core.entity.User;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionHistory;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
final class TransitionInvoke {
    private static final Logger log = LoggerFactory.getLogger(TransitionInvoke.class);
    private final SessionService sessionService;
    private final Optional<StatusCategoryService> statusCategoryService;
    private final WorkflowableTaskDao<?> workflowableTaskDao;
    private final Optional<ObserverService> observerService;
    private final PostFunctionExecute postFunctionExecute;
    private final WorkflowDaoImpl workflowDao;

    TransitionResult invoke(BcDescription bcDescription, WorkflowableTask task, WorkflowTransition transition) {
        TransitionResult transitionResult;
        TransitionResult transitionResult2 = transitionResult = this.isBackgroundExecution(transition) ? this.waitTransition(task, transition) : this.forceInvoke(bcDescription, task, transition);
        if (bcDescription != null && this.isFinalStep(transition.getDestinationStep()) && !this.isAutoClosedStep(transition.getDestinationStep()) && this.workflowableTaskDao.isClosedChild(task)) {
            transitionResult.replacePostActions(Collections.singletonList(PostAction.refreshBc((BcIdentifier)bcDescription)));
        }
        return transitionResult;
    }

    TransitionResult forceInvoke(BcDescription bcDescription, WorkflowableTask task, WorkflowTransition transition) {
        User previousAssignee = task.getAssignee();
        this.observerService.ifPresent(observerService -> observerService.addUserAsObserver(task, previousAssignee));
        List<PostAction> postActions = this.postFunctionExecute.execute(bcDescription, task, transition);
        WorkflowTransitionHistory transitionHistory = this.workflowDao.saveTransitionHistory(task, transition, this.sessionService.getSessionUser(), previousAssignee);
        this.updateTaskWorkflowStep(task, transition.getDestinationStep());
        log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d");
        return new TransitionResult(transitionHistory, postActions);
    }

    private TransitionResult waitTransition(WorkflowableTask task, WorkflowTransition transition) {
        log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0431\u0443\u0434\u0435\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d \u0432 \u0444\u043e\u043d\u0435");
        task.getWorkflowTask().setPendingTransition(this.workflowDao.createPendingTransition(transition, this.sessionService.getSessionUser(), this.sessionService.getSessionUserRole()));
        this.updateTaskWorkflowStep(task, transition.getDestinationStep());
        return new TransitionResult(null, Collections.emptyList());
    }

    private boolean isBackgroundExecution(WorkflowTransition transition) {
        return BooleanUtils.isTrue((Boolean)transition.getBackgroundExecution());
    }

    private void updateTaskWorkflowStep(WorkflowableTask task, WorkflowStep destinationStep) {
        if (task.getWorkflowTask() == null) {
            task.setWorkflowTask(this.workflowDao.createWorkflowTask(destinationStep));
        } else {
            task.getWorkflowTask().setWorkflowStep(destinationStep);
        }
        if (this.isInProgressStep(destinationStep)) {
            task.setStartDateFact(DateTimeUtil.now());
        } else if (this.isFinalStep(destinationStep)) {
            task.setResolutionDate(DateTimeUtil.now());
            this.closeRelatedTasks(task);
        }
    }

    private void closeRelatedTasks(WorkflowableTask task) {
        for (WorkflowableTask childTask : this.workflowableTaskDao.findAllLinksWithAutoClosed(task)) {
            WorkflowStep autoClosedStep;
            WorkflowStep childStep;
            WorkflowTask workflowTask = childTask.getWorkflowTask();
            if (workflowTask == null || (childStep = workflowTask.getWorkflowStep()) == null || this.isFinalStep(childStep) || (autoClosedStep = childStep.getWorkflowVersion().getAutoClosedStep()) == null) continue;
            WorkflowTransition transition = this.workflowDao.getTransitionBetweenSteps(childStep, autoClosedStep);
            if (transition != null) {
                this.invoke(null, childTask, transition);
                continue;
            }
            this.updateTaskWorkflowStep(childTask, autoClosedStep);
        }
    }

    private boolean isFinalStep(WorkflowStep step) {
        return this.statusCategoryService.map(service -> CoreDictionaries.TaskStatusCategory.isDone((LOV)service.getCategory(step.getLinkedStatusCd()))).orElse(false);
    }

    private boolean isAutoClosedStep(WorkflowStep step) {
        return this.statusCategoryService.map(service -> CoreDictionaries.TaskStatusCategory.isAutoClosed((LOV)service.getCategory(step.getLinkedStatusCd()))).orElse(false);
    }

    private boolean isInProgressStep(WorkflowStep step) {
        return "\u0412 \u0440\u0430\u0431\u043e\u0442\u0435".equals(step.getName());
    }

    public TransitionInvoke(SessionService sessionService, Optional<StatusCategoryService> statusCategoryService, WorkflowableTaskDao<?> workflowableTaskDao, Optional<ObserverService> observerService, PostFunctionExecute postFunctionExecute, WorkflowDaoImpl workflowDao) {
        this.sessionService = sessionService;
        this.statusCategoryService = statusCategoryService;
        this.workflowableTaskDao = workflowableTaskDao;
        this.observerService = observerService;
        this.postFunctionExecute = postFunctionExecute;
        this.workflowDao = workflowDao;
    }
}

