/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.function;

import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.engine.workflow.function.PostFunction;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowTransitionHistory;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collections;
import java.util.List;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Extension
@Service
public class PostFunctionAssignPrevious
implements PostFunction<WorkflowableTask, WorkflowPostFunction>,
ExtensionPoint {
    @Lazy
    @Autowired
    private WorkflowDao workflowDao;

    public LOV getType() {
        return WorkflowDictionaries.WfPostFunction.ASSIGN_PREVIOUS;
    }

    public List<PostAction> invoke(BcDescription bcDescription, WorkflowableTask task, WorkflowPostFunction postFunction) {
        WorkflowTransitionHistory lastTransitionHistoryStep = this.workflowDao.getLastTransitionHistory(task.getWorkflowTask());
        if (lastTransitionHistoryStep != null) {
            task.setAssignee(lastTransitionHistoryStep.getPreviousAssignee());
        }
        return Collections.emptyList();
    }
}

