/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.condition;

import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.util.DmnEngine;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.condition.ConditionChecker;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowCondition;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Optional;
import org.camunda.bpm.dmn.engine.DmnDecisionRuleResult;
import org.camunda.bpm.dmn.engine.DmnDecisionTableResult;
import org.pf4j.Extension;
import org.pf4j.ExtensionPoint;
import org.springframework.stereotype.Service;

@Extension
@Service
public class CheckDmn
implements ConditionChecker<WorkflowableTask, WorkflowCondition>,
ExtensionPoint {
    private final DmnEngine dmnEngine;
    private final WorkflowSettings<?> workflowSettings;

    public LOV getType() {
        return WorkflowDictionaries.WfCondition.DMN;
    }

    public boolean check(WorkflowableTask task, WorkflowCondition condition, WorkflowTransition transition) {
        return (Boolean)Optional.ofNullable(this.dmnEngine.evaluate(condition.getDmn(), (BaseEntity)task, this.workflowSettings.getDtoClass())).map(DmnDecisionTableResult::getFirstResult).map(DmnDecisionRuleResult::getFirstEntry).orElse(false);
    }

    public CheckDmn(DmnEngine dmnEngine, WorkflowSettings<?> workflowSettings) {
        this.dmnEngine = dmnEngine;
        this.workflowSettings = workflowSettings;
    }
}

