/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.core.util.DateTimeUtil;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.engine.workflow.services.WorkflowStepTermService;
import io.tesler.model.workflow.entity.WorkflowableTask;
import org.pf4j.Extension;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Extension
public class WorkflowStepTermServiceImpl
implements WorkflowStepTermService {
    private final WorkflowableTaskDao<?> workflowableTaskDao;
    private final WorkflowEngine workflowEngine;

    @Transactional
    public void invokeOverdueTransitions() {
        for (WorkflowableTask task : this.workflowableTaskDao.getTasksWithStepTermOverdue(DateTimeUtil.now())) {
            this.workflowEngine.invokeAutoTransition(task, task.getWorkflowTask().getWorkflowStep().getOverdueTransition());
        }
    }

    public WorkflowStepTermServiceImpl(WorkflowableTaskDao<?> workflowableTaskDao, WorkflowEngine workflowEngine) {
        this.workflowableTaskDao = workflowableTaskDao;
        this.workflowEngine = workflowEngine;
    }
}

