/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.impl.BcDescription;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.services.AssigneeRecommender;
import io.tesler.engine.workflow.services.ConditionCheck;
import io.tesler.engine.workflow.services.TransitionCheck;
import io.tesler.engine.workflow.services.TransitionInvoke;
import io.tesler.engine.workflow.services.TransitionResult;
import io.tesler.engine.workflow.services.TransitionValidate;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.core.entity.User;
import io.tesler.model.workflow.entity.TaskField;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowStepField;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTaskChildBcAvailability;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@Extension
public class WorkflowEngineImpl
implements WorkflowEngine {
    private static final Logger log = LoggerFactory.getLogger(WorkflowEngineImpl.class);
    private final WorkflowSettings<?> workflowSettings;
    private final JpaDao jpaDao;
    private final ConditionCheck conditionCheck;
    private final TransitionCheck transitionCheck;
    private final TransitionValidate transitionValidate;
    private final TransitionInvoke transitionInvoke;
    private final AssigneeRecommender assigneeRecommender;
    private final WorkflowDaoImpl workflowDao;

    public void setInitialStep(WorkflowableTask task) {
        this.setCustomStep(task, this.workflowDao.getInitialStep(task.getProject(), task.getTaskType()));
    }

    public void setCustomStep(WorkflowableTask task, WorkflowStep step) {
        if (task.getWorkflowTask() == null) {
            task.setWorkflowTask(this.workflowDao.createWorkflowTask(step));
        } else {
            task.getWorkflowTask().setWorkflowStep(step);
        }
    }

    public List<WorkflowTransition> getTransitions(WorkflowableTask task) {
        log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u043e\u0432 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", (Object)task.getId());
        if (this.transitionValidate.isPendingTransitionTask(task)) {
            log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f, \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b");
            return Collections.emptyList();
        }
        WorkflowStep currentStep = this.workflowDao.getCurrentStep(task);
        log.debug("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0448\u0430\u0433 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 '{}' id: {}", (Object)currentStep.getName(), (Object)currentStep.getId());
        return this.workflowDao.getTransitions(currentStep).stream().filter(transition -> this.transitionCheck.isAvailable(task, (WorkflowTransition)transition)).collect(Collectors.toList());
    }

    public TransitionResult invokeTransition(BcDescription bcDescription, WorkflowableTask task, WorkflowTransition transition, List<String> preInvokeParameters) {
        log.debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {} \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", new Object[]{transition.getName(), transition.getId(), task.getId()});
        this.transitionValidate.validate(task, transition, true, preInvokeParameters);
        return this.transitionInvoke.invoke(bcDescription, task, transition);
    }

    public TransitionResult invokeAutoTransition(WorkflowableTask task, WorkflowTransition transition) {
        log.debug("\u0412\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0430\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {} \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", new Object[]{transition.getName(), transition.getId(), task.getId()});
        this.transitionValidate.validate(task, transition, false, Collections.emptyList());
        return this.transitionInvoke.invoke(null, task, transition);
    }

    public void forceInvokeAutoTransition(WorkflowableTask task, WorkflowTransition transition) {
        this.transitionInvoke.forceInvoke(null, task, transition);
    }

    public void forceInvokeAutoTransitionToHiddenStep(WorkflowableTask task) {
        WorkflowStep currentStep;
        WorkflowStep hiddenStep;
        WorkflowTask workflowTask = task.getWorkflowTask();
        if (workflowTask != null && (hiddenStep = this.workflowDao.getHiddenStep((currentStep = workflowTask.getWorkflowStep()).getWorkflowVersion())) != null) {
            WorkflowTransition transition = this.workflowDao.getTransitionBetweenSteps(currentStep, hiddenStep);
            this.transitionInvoke.forceInvoke(null, task, transition);
        }
    }

    public boolean isChildBcDisabled(BcIdentifier bcIdentifier, WorkflowableTask task) {
        WorkflowStep step = this.workflowDao.getCurrentStep(task);
        if (step == null) {
            return false;
        }
        return this.workflowDao.getWorkflowTaskChildBcAvailabilities(step).stream().filter(childBcAvailability -> Objects.equals(childBcAvailability.getBcName(), bcIdentifier.getName())).anyMatch(childBcAvailability -> this.conditionCheck.isAvailable(task, this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), (WorkflowTaskChildBcAvailability)childBcAvailability), null));
    }

    public List<String> getDisableFields(WorkflowableTask task) {
        Stream<Object> disableFields;
        log.debug("\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u043f\u043e\u043b\u0435\u0439 \u0434\u043b\u044f \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 id: {}", (Object)task.getId());
        if (this.transitionValidate.isPendingTransitionTask(task)) {
            log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f, \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e");
            disableFields = this.jpaDao.getList(TaskField.class).stream();
        } else {
            WorkflowStep currentStep = this.workflowDao.getCurrentStep(task);
            log.debug("\u0422\u0435\u043a\u0443\u0449\u0438\u0439 \u0448\u0430\u0433 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 '{}' id: {}", (Object)currentStep.getName(), (Object)currentStep.getId());
            List<WorkflowStepField> stepFields = this.workflowDao.getStepFields(currentStep);
            if (stepFields.isEmpty()) {
                log.debug("\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u044b\u0445 \u043f\u043e\u043b\u0435\u0439 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d");
            }
            disableFields = stepFields.stream().filter(stepField -> stepField.getTaskField() != null).filter(stepField -> {
                log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u043e\u0441\u0442\u0438 \u043f\u043e\u043b\u044f '{}'", (Object)stepField.getTaskField().getKey());
                boolean available = this.conditionCheck.isAvailable(task, this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), (WorkflowStepField)stepField), null);
                log.debug(available ? "\u041f\u043e\u043b\u0435 \u043d\u0435\u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u043e" : "\u041f\u043e\u043b\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0443\u0435\u043c\u043e");
                return available;
            }).map(WorkflowStepField::getTaskField);
        }
        return disableFields.map(TaskField::getKey).collect(Collectors.toList());
    }

    public Specification<User> getAssigneeRecommendationSpecification(WorkflowableTask task) {
        return this.assigneeRecommender.recommend(task);
    }

    public boolean checkRequiredFieldsForTransition(WorkflowTransition transition) {
        return transition.getCheckRequiredFields();
    }

    public WorkflowEngineImpl(WorkflowSettings<?> workflowSettings, JpaDao jpaDao, ConditionCheck conditionCheck, TransitionCheck transitionCheck, TransitionValidate transitionValidate, TransitionInvoke transitionInvoke, AssigneeRecommender assigneeRecommender, WorkflowDaoImpl workflowDao) {
        this.workflowSettings = workflowSettings;
        this.jpaDao = jpaDao;
        this.conditionCheck = conditionCheck;
        this.transitionCheck = transitionCheck;
        this.transitionValidate = transitionValidate;
        this.transitionInvoke = transitionInvoke;
        this.assigneeRecommender = assigneeRecommender;
        this.workflowDao = workflowDao;
    }
}

