/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.engine.workflow.services.WaitingRemoteSystemService;
import io.tesler.model.core.dao.JpaDao;
import io.tesler.model.workflow.entity.WaitingRemoteSystem;
import io.tesler.model.workflow.entity.WorkflowPostFunction;
import io.tesler.model.workflow.entity.WorkflowableTask;
import org.pf4j.Extension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Extension
public class WaitingRemoteSystemServiceImpl
implements WaitingRemoteSystemService {
    @Autowired
    private JpaDao jpaDao;

    public void wait(WorkflowableTask task, WorkflowPostFunction postFunction, String correlationId) {
        WaitingRemoteSystem waiting = new WaitingRemoteSystem();
        waiting.setCorrelationId(correlationId);
        waiting.setWorkflowTask(task.getWorkflowTask());
        waiting.setPostFunction(postFunction);
        waiting.setPostFunctionCd(postFunction.getActionCd());
        waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.NOT_RECEIVED);
        this.jpaDao.save((Object)waiting);
    }

    public void wait(WaitingRemoteSystem srcWaiting, String newCorrelationId) {
        WaitingRemoteSystem waiting = new WaitingRemoteSystem();
        waiting.setParentWaiting(this.getRootWaiting(srcWaiting));
        waiting.setCorrelationId(newCorrelationId);
        waiting.setWorkflowTask(srcWaiting.getWorkflowTask());
        waiting.setPostFunction(srcWaiting.getPostFunction());
        waiting.setPostFunctionCd(srcWaiting.getPostFunctionCd());
        waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.NOT_RECEIVED);
        this.jpaDao.save((Object)waiting);
    }

    public WaitingRemoteSystem getRootWaiting(WaitingRemoteSystem waiting) {
        WaitingRemoteSystem tmp = waiting;
        while (tmp.getParentWaiting() != null) {
            tmp = tmp.getParentWaiting();
        }
        return tmp;
    }
}

