/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dto.PreInvokeEvent;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.exception.UnconfirmedException;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.services.ConditionCheck;
import io.tesler.engine.workflow.services.PreInvoker;
import io.tesler.engine.workflow.services.TransitionCheck;
import io.tesler.engine.workflow.validation.TransitionValidator;
import io.tesler.engine.workflow.validation.UnsupportedValidator;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
final class TransitionValidate {
    private static final Logger log = LoggerFactory.getLogger(TransitionValidate.class);
    private final WorkflowSettings<?> workflowSettings;
    private final WorkflowDaoImpl workflowDao;
    private final ConditionCheck conditionCheck;
    private final TransitionCheck transitionCheck;
    private final PreInvoker preInvoker;
    private final TransitionValidator<? extends WorkflowableTask, ? extends WorkflowTransitionValidation> defaultTransitionValidator;
    private final Map<LOV, TransitionValidator<? extends WorkflowableTask, ? extends WorkflowTransitionValidation>> transitionValidators;

    TransitionValidate(WorkflowSettings<?> workflowSettings, WorkflowDaoImpl workflowDao, ConditionCheck conditionCheck, TransitionCheck transitionCheck, PreInvoker preInvoker, UnsupportedValidator defaultTransitionValidator, List<TransitionValidator<? extends WorkflowableTask, ? extends WorkflowTransitionValidation>> transitionValidators) {
        this.workflowSettings = workflowSettings;
        this.workflowDao = workflowDao;
        this.conditionCheck = conditionCheck;
        this.transitionCheck = transitionCheck;
        this.preInvoker = preInvoker;
        this.defaultTransitionValidator = defaultTransitionValidator;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TransitionValidator<? extends WorkflowableTask, ? extends WorkflowTransitionValidation> transitionValidator : transitionValidators) {
            if (transitionValidator.getType() == null) continue;
            builder.put((Object)transitionValidator.getType(), transitionValidator);
        }
        this.transitionValidators = builder.build();
    }

    void validate(WorkflowableTask task, WorkflowTransition transition, boolean fullValidation, Collection<String> confirmedPreInvokeKeys) {
        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {}", (Object)transition.getName(), (Object)transition.getId());
        this.check(task, transition, fullValidation);
        if (fullValidation) {
            ArrayList messages = new ArrayList();
            ArrayList<PreInvokeEvent> preInvokeEvents = new ArrayList<PreInvokeEvent>();
            List<WorkflowTransitionConditionGroup> conditionGroups = this.workflowDao.getTransitionConditionGroups(transition, WorkflowDictionaries.ConditionGroupType.VALIDATION);
            if (conditionGroups.isEmpty()) {
                log.debug("\u0421\u043f\u0438\u0441\u043e\u043a \u0433\u0440\u0443\u043f\u043f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043f\u0443\u0441\u0442, \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
            }
            for (WorkflowTransitionConditionGroup conditionGroup : conditionGroups) {
                log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0433\u0440\u0443\u043f\u043f\u044b \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' id: {}", (Object)conditionGroup.getName(), (Object)conditionGroup.getId());
                List conditions = this.workflowDao.getConditions(this.workflowSettings.getConditionExtensionClass(), conditionGroup);
                if (!this.conditionCheck.isAvailable(task, conditions, transition)) continue;
                List validations = this.workflowDao.getValidations(this.workflowSettings.getTransitionValidationExtensionClass(), conditionGroup);
                for (WorkflowTransitionValidation transitionValidation : validations) {
                    if (Objects.equals(transitionValidation.getValidCd(), CoreDictionaries.WfTransitionValidate.TRANSITION_PRE_INVOKE)) {
                        preInvokeEvents.add(this.preInvoker.invoke(task, transitionValidation, confirmedPreInvokeKeys));
                        continue;
                    }
                    TransitionValidator<? extends WorkflowableTask, ? extends WorkflowTransitionValidation> validator = this.transitionValidators.getOrDefault(transitionValidation.getValidCd(), this.defaultTransitionValidator);
                    List errors = validator.validate(task, transitionValidation);
                    if (errors.isEmpty()) {
                        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 {} id: {} \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e", (Object)transitionValidation.getValidCd().getKey(), (Object)transitionValidation.getId());
                        continue;
                    }
                    log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 {} id: {} \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u043b\u0430\u0441\u044c \u0441 \u043e\u0448\u0438\u0431\u043a\u043e\u0439", (Object)transitionValidation.getValidCd().getKey(), (Object)transitionValidation.getId());
                    messages.addAll(errors);
                }
            }
            if (!messages.isEmpty()) {
                log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 \u043d\u0435 \u043f\u0440\u043e\u0439\u0434\u0435\u043d\u0430, \u043f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d");
                throw new BusinessException().addPopup(messages);
            }
            this.executePreInvokeEvents(preInvokeEvents);
        }
    }

    private void check(WorkflowableTask task, WorkflowTransition transition, boolean checkConditions) {
        if (this.isPendingTransitionTask(task)) {
            log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0435\u0442\u0441\u044f, \u0434\u0440\u0443\u0433\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b");
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.pending_transition_exists"));
        }
        WorkflowStep currentStep = this.workflowDao.getCurrentStep(task);
        if (transition == null || !com.google.common.base.Objects.equal((Object)currentStep, (Object)transition.getSourceStep()) || !com.google.common.base.Objects.equal((Object)currentStep.getWorkflowVersion(), (Object)transition.getDestinationStep().getWorkflowVersion()) || checkConditions && !this.transitionCheck.isAvailable(task, transition)) {
            log.debug("\u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0438\u0437 \u0448\u0430\u0433\u0430 '{}'.", (Object)currentStep.getName());
            throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.transition_unavailable_for_source", (Object[])new Object[]{currentStep.getName()}));
        }
    }

    private void executePreInvokeEvents(List<PreInvokeEvent> preInvokeEvents) {
        if (Objects.nonNull(preInvokeEvents)) {
            preInvokeEvents.removeIf(Objects::isNull);
            if (!preInvokeEvents.isEmpty()) {
                log.debug("\u0411\u0443\u0434\u0435\u0442 \u043f\u043e\u043a\u0430\u0437\u0430\u043d\u043e \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u0435 \u043e\u043a\u043d\u043e. \u041f\u0435\u0440\u0435\u0445\u043e\u0434 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d.");
                throw new UnconfirmedException().addPreInvokeEvents(preInvokeEvents);
            }
        }
    }

    boolean isPendingTransitionTask(WorkflowableTask task) {
        return task.getWorkflowTask() != null && task.getWorkflowTask().getPendingTransition() != null;
    }
}

