/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import com.google.common.collect.ImmutableMap;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.core.dto.PreInvokeEvent;
import io.tesler.engine.workflow.preinvoke.AlwaysPreInvoke;
import io.tesler.engine.workflow.services.PreInvokeConditionChecker;
import io.tesler.model.workflow.entity.WorkflowTransitionValidation;
import io.tesler.model.workflow.entity.WorkflowableTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class PreInvoker {
    private static final Logger log = LoggerFactory.getLogger(PreInvoker.class);
    private static final String PRE_INVOKE_KEY_SEPARATOR = "_";
    private final PreInvokeConditionChecker<? extends WorkflowableTask> defaultConditionChecker;
    private final Map<LOV, PreInvokeConditionChecker<? extends WorkflowableTask>> preInvokeConditionCheckers;

    PreInvoker(AlwaysPreInvoke defaultConditionChecker, List<PreInvokeConditionChecker<? extends WorkflowableTask>> conditionCheckers) {
        this.defaultConditionChecker = defaultConditionChecker;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PreInvokeConditionChecker<? extends WorkflowableTask> conditionChecker : conditionCheckers) {
            if (conditionChecker.getType() == null) continue;
            builder.put((Object)conditionChecker.getType(), conditionChecker);
        }
        this.preInvokeConditionCheckers = builder.build();
    }

    PreInvokeEvent invoke(WorkflowableTask task, WorkflowTransitionValidation transitionValidation, Collection<String> confirmedPreInvokeKeys) {
        String preInvokeKey = this.getPreInvokeKey(transitionValidation);
        log.debug("\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u043f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0439 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}'", (Object)preInvokeKey);
        if (Objects.isNull(confirmedPreInvokeKeys) || !confirmedPreInvokeKeys.contains(preInvokeKey)) {
            log.debug("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' \u043d\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e", (Object)preInvokeKey);
            LOV preInvokeTypeCd = transitionValidation.getPreInvokeTypeCd();
            if (Objects.nonNull(preInvokeTypeCd) && StringUtils.isNotBlank((CharSequence)preInvokeTypeCd.getKey())) {
                PreInvokeConditionChecker<? extends WorkflowableTask> conditionChecker = this.preInvokeConditionCheckers.getOrDefault(transitionValidation.getPreInvokeCondCd(), this.defaultConditionChecker);
                if (conditionChecker.check(task, transitionValidation)) {
                    log.debug("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 {} id: {} \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u043e\u043a\u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", (Object)transitionValidation.getPreInvokeCondCd(), (Object)transitionValidation.getId());
                    return PreInvokeEvent.of((String)preInvokeKey, (String)preInvokeTypeCd.getKey(), (String)transitionValidation.getPreInvokeMessage());
                }
                log.debug("\u0423\u0441\u043b\u043e\u0432\u0438\u0435 {} id: {} \u0434\u043b\u044f \u0432\u044b\u0437\u043e\u0432\u0430 \u0434\u0438\u0430\u043b\u043e\u0433\u043e\u0432\u043e\u0433\u043e \u043e\u043a\u043d\u0430 \u043d\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u043e", (Object)transitionValidation.getPreInvokeCondCd(), (Object)transitionValidation.getId());
            } else {
                log.debug("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0430 '{}' \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u043e", (Object)preInvokeKey);
            }
        }
        return null;
    }

    private String getPreInvokeKey(WorkflowTransitionValidation wfValidation) {
        return wfValidation.getValidCd().getKey().toLowerCase() + PRE_INVOKE_KEY_SEPARATOR + wfValidation.getId();
    }
}

