/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.engine.workflow.services;

import io.tesler.api.data.dictionary.CoreDictionaries;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.exception.IntegrationException;
import io.tesler.engine.workflow.dao.WorkflowDaoImpl;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.RemoteSystemResponseHandler;
import io.tesler.engine.workflow.services.TransitionResult;
import io.tesler.engine.workflow.services.WaitingRemoteSystemService;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.model.workflow.entity.WaitingRemoteSystem;
import io.tesler.model.workflow.entity.WorkflowPostFunctionTrigger;
import io.tesler.model.workflow.entity.WorkflowTask;
import io.tesler.model.workflow.entity.WorkflowTransition;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Extension
public class RemoteSystemResponseHandlerImpl
implements RemoteSystemResponseHandler {
    private static final Logger log = LoggerFactory.getLogger(RemoteSystemResponseHandlerImpl.class);
    private final WorkflowEngine workflowEngine;
    private final WorkflowDaoImpl workflowDao;
    private final WorkflowableTaskDao<?> workflowableTaskDao;
    private final WaitingRemoteSystemService waitingRemoteSystemService;

    @Transactional
    public WaitingRemoteSystem handleFinalResponse(String correlationId, RemoteSystemResponseHandler.ResponseCode responseCode) {
        WaitingRemoteSystem waiting = this.workflowDao.getWaitingRemoteSystem(correlationId);
        if (waiting == null) {
            log.warn(String.format("\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0435\u0439 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u043e\u0442\u0432\u0435\u0442\u0430:%n\tcorrelationId: %s%n\tresponseCode: %s", correlationId, responseCode));
            throw new IntegrationException("\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0435\u0439 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u043e\u0442\u0432\u0435\u0442\u0430: correlationId: " + correlationId + ", responseCode: " + responseCode);
        }
        WorkflowTask workflowTask = waiting.getWorkflowTask();
        waiting.setResponseStep(workflowTask.getWorkflowStep());
        WorkflowPostFunctionTrigger trigger = this.workflowDao.getPostFunctionTrigger(waiting.getPostFunction(), workflowTask.getWorkflowStep());
        if (trigger == null) {
            waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_AND_ERROR);
            log.warn(String.format("\u0414\u043b\u044f \u0448\u0430\u0433\u0430 %s \u043d\u0435 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043e \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430:%n\tcorrelationId: %s%n\tresponseCode: %s", workflowTask.getWorkflowStep().getName(), correlationId, responseCode));
        } else {
            try {
                TransitionResult transitionResult = this.workflowEngine.invokeAutoTransition(this.workflowableTaskDao.getTask(workflowTask), (WorkflowTransition)responseCode.getTransitionGetter().apply(trigger));
                this.setSuccessStatus(waiting);
                waiting.setTransitionHistory(transitionResult.getTransitionHistory());
            }
            catch (Exception e) {
                waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_AND_ERROR);
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return waiting;
    }

    private void setSuccessStatus(WaitingRemoteSystem waiting) {
        WaitingRemoteSystem rootWaiting = this.waitingRemoteSystemService.getRootWaiting(waiting);
        rootWaiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_AND_SUCCESS);
        for (WaitingRemoteSystem childWaiting : rootWaiting.getChildWaiting()) {
            childWaiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_AND_SUCCESS);
        }
    }

    @Transactional
    public WaitingRemoteSystem handlePartialResponse(String correlationId, String newCorrelationId, RemoteSystemResponseHandler.ResponseCode responseCode) {
        WaitingRemoteSystem waiting = this.workflowDao.getWaitingRemoteSystem(correlationId);
        if (waiting == null) {
            log.warn(String.format("\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0435\u0439 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u043e\u0442\u0432\u0435\u0442\u0430:\n\tcorrelationId: %s\n\tnewCorrelationId: %s", correlationId, newCorrelationId));
            throw new IntegrationException("\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0435\u0439 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u043e\u0442\u0432\u0435\u0442\u0430: correlationId: " + correlationId + ", newCorrelationId: " + newCorrelationId);
        }
        if (newCorrelationId != null) {
            this.waitingRemoteSystemService.wait(waiting, newCorrelationId);
        }
        WorkflowTask workflowTask = waiting.getWorkflowTask();
        waiting.setResponseStep(workflowTask.getWorkflowStep());
        if (responseCode != null) {
            WorkflowPostFunctionTrigger trigger = this.workflowDao.getPostFunctionTrigger(waiting.getPostFunction(), workflowTask.getWorkflowStep());
            if (trigger == null) {
                waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_PARTIALLY_AND_ERROR);
                log.warn(String.format("\u0414\u043b\u044f \u0448\u0430\u0433\u0430 %s \u043d\u0435 \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043e \u043e\u0436\u0438\u0434\u0430\u043d\u0438\u0435 \u043e\u0442\u0432\u0435\u0442\u0430:%n\tcorrelationId: %s%n\tresponseCode: %s", workflowTask.getWorkflowStep().getName(), correlationId, responseCode));
            } else {
                try {
                    TransitionResult transitionResult = this.workflowEngine.invokeAutoTransition(this.workflowableTaskDao.getTask(workflowTask), (WorkflowTransition)responseCode.getTransitionGetter().apply(trigger));
                    waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_PARTIALLY);
                    waiting.setTransitionHistory(transitionResult.getTransitionHistory());
                }
                catch (Exception e) {
                    waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_PARTIALLY_AND_ERROR);
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        } else {
            waiting.setStatusCd(CoreDictionaries.RemoteSystemResponse.RECEIVED_PARTIALLY);
        }
        return waiting;
    }

    @Transactional
    public WaitingRemoteSystem handlePartialResponse(String correlationId, RemoteSystemResponseHandler.ResponseCode responseCode) {
        return this.handlePartialResponse(correlationId, null, responseCode);
    }

    @Transactional
    public WaitingRemoteSystem handlePartialResponse(String correlationId, String newCorrelationId) {
        return this.handlePartialResponse(correlationId, newCorrelationId, null);
    }

    @Transactional
    public WaitingRemoteSystem handlePartialResponse(String correlationId) {
        return this.handlePartialResponse(correlationId, null, null);
    }

    public LOV getPostFunctionByCorrelationId(String correlationId) {
        WaitingRemoteSystem waiting = this.workflowDao.getWaitingRemoteSystem(correlationId);
        if (waiting == null) {
            log.warn(String.format("\u041d\u0435\u0442 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0435\u0439 \u043e\u0436\u0438\u0434\u0430\u044e\u0449\u0438\u0445 \u043e\u0442\u0432\u0435\u0442\u0430:\n\tcorrelationId: %s", correlationId));
            return null;
        }
        return waiting.getPostFunctionCd();
    }

    public RemoteSystemResponseHandlerImpl(WorkflowEngine workflowEngine, WorkflowDaoImpl workflowDao, WorkflowableTaskDao<?> workflowableTaskDao, WaitingRemoteSystemService waitingRemoteSystemService) {
        this.workflowEngine = workflowEngine;
        this.workflowDao = workflowDao;
        this.workflowableTaskDao = workflowableTaskDao;
        this.waitingRemoteSystemService = waitingRemoteSystemService;
    }
}

