/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.ResultPage;
import io.tesler.api.data.dto.DataResponseDTO;
import io.tesler.api.service.PluginAware;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.AbstractResponseService;
import io.tesler.core.dao.BaseDAO;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.PostAction;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.action.Actions;
import io.tesler.engine.workflow.WorkflowSettings;
import io.tesler.engine.workflow.dao.WorkflowableTaskDao;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.engine.workflow.services.WorkflowEngine;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTask_;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowVersion;
import io.tesler.model.workflow.entity.WorkflowableTask;
import io.tesler.model.workflow.entity.WorkflowableTask_;
import io.tesler.source.dto.WorkflowTaskMigrationDto;
import io.tesler.source.dto.WorkflowTaskMigrationDto_;
import io.tesler.source.services.data.WorkflowTaskMigrationService;
import io.tesler.source.services.meta.WorkflowTaskMigrationFieldMetaBuilder;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@PluginAware
public class WorkflowTaskMigrationServiceImpl
extends AbstractResponseService<WorkflowTaskMigrationDto, WorkflowableTask>
implements WorkflowTaskMigrationService {
    @Autowired
    private WorkflowSettings<?> workflowSettings;
    @Autowired
    private WorkflowableTaskDao<?> workflowableTaskDao;
    @Autowired
    private WorkflowEngine workflowEngine;
    @Autowired
    private WorkflowDao workflowDao;

    public WorkflowTaskMigrationServiceImpl() {
        super(WorkflowTaskMigrationDto.class, WorkflowableTask.class, null, WorkflowTaskMigrationFieldMetaBuilder.class);
    }

    protected String getFetchGraphName(BusinessComponent bc) {
        return null;
    }

    public WorkflowableTask getOneAsEntity(BusinessComponent bc) {
        return this.workflowableTaskDao.getTask(bc.getIdAsLong());
    }

    public ResultPage<WorkflowTaskMigrationDto> getList(BaseDAO dao, BusinessComponent bc) {
        return this.getList(dao, bc, this.workflowSettings.getEntityClass(), this.typeOfDTO);
    }

    public long count(BaseDAO dao, BusinessComponent bc) {
        return this.count(dao, bc, this.workflowSettings.getEntityClass(), this.typeOfDTO);
    }

    protected Specification<WorkflowableTask> getParentSpecification(BusinessComponent bc) {
        WorkflowVersion version = (WorkflowVersion)this.baseDAO.findById(WorkflowVersion.class, bc.getParentIdAsLong());
        return (Specification & Serializable)(root, query, cb) -> cb.and(new Predicate[]{cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.workflowName), (Object)version.getWorkflow().getName()), cb.equal((Expression)root.get(WorkflowableTask_.workflowTask).get(WorkflowTask_.version), (Object)version.getVersion()), cb.equal((Expression)root.get(WorkflowableTask_.templateFlg), (Object)(WorkflowServiceAssociation.wfTemplateMigration.isBc((BcIdentifier)bc) ? Boolean.TRUE : Boolean.FALSE))});
    }

    public ActionResultDTO<WorkflowTaskMigrationDto> updateEntity(BusinessComponent bc, DataResponseDTO data) {
        WorkflowableTask entity = this.workflowableTaskDao.getTask(bc.getIdAsLong());
        WorkflowTaskMigrationDto dto = (WorkflowTaskMigrationDto)data;
        if (data.hasChangedFields()) {
            if (data.isFieldChanged(WorkflowTaskMigrationDto_.newStepId)) {
                this.workflowEngine.setCustomStep(entity, (WorkflowStep)this.baseDAO.findById(WorkflowStep.class, dto.getNewStepId()));
            }
            if (data.isFieldChanged(WorkflowTaskMigrationDto_.newAutomaticTransitionId)) {
                WorkflowTransition automaticTransition = this.workflowDao.getActiveWorkflowTransitionByName(dto.getNewAutomaticTransitionId());
                if (!Objects.equals(automaticTransition.getSourceStep(), this.workflowDao.getWorkflowStep(entity.getWorkflowTask()))) {
                    throw new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.automatic_transition_mismatch"));
                }
                entity.setAutomaticTransitionName(automaticTransition.getName());
            }
        }
        WorkflowTaskMigrationDto updatedDto = (WorkflowTaskMigrationDto)this.entityToDto(bc, (BaseEntity)entity);
        return new ActionResultDTO((DataResponseDTO)updatedDto).setAction(PostAction.refreshBc((BcIdentifier)bc));
    }

    public Actions<WorkflowTaskMigrationDto> getActions() {
        return Actions.builder().save().add().build();
    }
}

