/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source;

import io.tesler.api.data.dto.rowmeta.ActionDTO;
import io.tesler.core.service.action.ActionScope;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionGroup;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public final class WorkflowActionUtils {
    private static final String WF_TRANSITION_ID = "wf_";
    private static final TransitionActionGroup WITHOUT_GROUP = new TransitionActionGroup(null, null, null, null);

    public static boolean isTransitionAction(String actionName) {
        return actionName.startsWith(WF_TRANSITION_ID);
    }

    public static String actionNameFromTransitionName(WorkflowTransition transition) {
        return WF_TRANSITION_ID + transition.getName();
    }

    public static String transitionNameFromActionName(String actionName) {
        return actionName.replace(WF_TRANSITION_ID, "");
    }

    public static List<ActionDTO> getActions(List<WorkflowTransition> transitions) {
        Map transitionGroup = transitions.stream().collect(Collectors.groupingBy(transition -> Optional.ofNullable(transition.getWorkflowTransitionGroup()).map(x$0 -> new TransitionActionGroup((WorkflowTransitionGroup)x$0)).orElse(WITHOUT_GROUP), Collectors.mapping(Function.identity(), Collectors.toList())));
        ArrayList result = new ArrayList();
        Optional.ofNullable(transitionGroup.remove(WITHOUT_GROUP)).ifPresent(workflowTransitions -> workflowTransitions.forEach(transition -> result.add(new TransitionAction((WorkflowTransition)transition))));
        transitionGroup.forEach((key, value) -> result.add(new TransitionAction((TransitionActionGroup)key, (List)value)));
        return result.stream().sorted(Comparator.comparing(TransitionAction::getSeq, Comparator.nullsLast(Comparator.naturalOrder()))).map(TransitionAction::getActionDTO).collect(Collectors.toList());
    }

    @Generated
    private WorkflowActionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class TransitionActionGroup {
        private final String type;
        private final String text;
        private final Integer maxGroupVisualButtonsCount;
        private final Long seq;

        private TransitionActionGroup(WorkflowTransitionGroup transitionGroup) {
            this(transitionGroup.getNameButtonYet(), transitionGroup.getDescription(), transitionGroup.getMaxShowButtonsInGroup(), transitionGroup.getSeq());
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public Integer getMaxGroupVisualButtonsCount() {
            return this.maxGroupVisualButtonsCount;
        }

        @Generated
        public Long getSeq() {
            return this.seq;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransitionActionGroup)) {
                return false;
            }
            TransitionActionGroup other = (TransitionActionGroup)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            Integer this$maxGroupVisualButtonsCount = this.getMaxGroupVisualButtonsCount();
            Integer other$maxGroupVisualButtonsCount = other.getMaxGroupVisualButtonsCount();
            if (this$maxGroupVisualButtonsCount == null ? other$maxGroupVisualButtonsCount != null : !((Object)this$maxGroupVisualButtonsCount).equals(other$maxGroupVisualButtonsCount)) {
                return false;
            }
            Long this$seq = this.getSeq();
            Long other$seq = other.getSeq();
            return !(this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransitionActionGroup;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            Integer $maxGroupVisualButtonsCount = this.getMaxGroupVisualButtonsCount();
            result = result * 59 + ($maxGroupVisualButtonsCount == null ? 43 : ((Object)$maxGroupVisualButtonsCount).hashCode());
            Long $seq = this.getSeq();
            result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
            return result;
        }

        @Generated
        public TransitionActionGroup(String type, String text, Integer maxGroupVisualButtonsCount, Long seq) {
            this.type = type;
            this.text = text;
            this.maxGroupVisualButtonsCount = maxGroupVisualButtonsCount;
            this.seq = seq;
        }
    }

    private static class TransitionAction {
        private final Long seq;
        private final ActionDTO actionDTO;

        private TransitionAction(WorkflowTransition workflowTransition) {
            this.actionDTO = new ActionDTO(WorkflowActionUtils.actionNameFromTransitionName(workflowTransition), workflowTransition.getText());
            this.actionDTO.setAvailable(true);
            this.actionDTO.setScope(ActionScope.RECORD.toString().toLowerCase());
            this.actionDTO.setIcon(workflowTransition.getIconCode());
            this.seq = workflowTransition.getSeq();
        }

        private TransitionAction(TransitionActionGroup transitionActionGroup, List<WorkflowTransition> workflowTransitions) {
            ArrayList groupedActions = new ArrayList();
            workflowTransitions.forEach(transition -> groupedActions.add(new TransitionAction((WorkflowTransition)transition)));
            List actionDTOS = groupedActions.stream().sorted(Comparator.comparing(TransitionAction::getSeq, Comparator.nullsLast(Comparator.naturalOrder()))).map(TransitionAction::getActionDTO).collect(Collectors.toList());
            this.actionDTO = new ActionDTO(transitionActionGroup.getType(), transitionActionGroup.getText(), transitionActionGroup.getMaxGroupVisualButtonsCount().intValue(), actionDTOS);
            this.actionDTO.setAvailable(true);
            this.actionDTO.setScope(ActionScope.RECORD.toString().toLowerCase());
            this.seq = transitionActionGroup.getSeq();
        }

        @Generated
        public Long getSeq() {
            return this.seq;
        }

        @Generated
        public ActionDTO getActionDTO() {
            return this.actionDTO;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransitionAction)) {
                return false;
            }
            TransitionAction other = (TransitionAction)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$seq = this.getSeq();
            Long other$seq = other.getSeq();
            if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
                return false;
            }
            ActionDTO this$actionDTO = this.getActionDTO();
            ActionDTO other$actionDTO = other.getActionDTO();
            return !(this$actionDTO == null ? other$actionDTO != null : !this$actionDTO.equals(other$actionDTO));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransitionAction;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $seq = this.getSeq();
            result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
            ActionDTO $actionDTO = this.getActionDTO();
            result = result * 59 + ($actionDTO == null ? 43 : $actionDTO.hashCode());
            return result;
        }

        @Generated
        public TransitionAction(Long seq, ActionDTO actionDTO) {
            this.seq = seq;
            this.actionDTO = actionDTO;
        }
    }
}

