/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.util.i18n.ErrorMessageSource;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.exception.BusinessException;
import io.tesler.core.service.action.Actions;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.workflow.entity.WorkflowStep;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionGroup_;
import io.tesler.source.dto.WorkflowTransitionGroupDto;
import io.tesler.source.dto.WorkflowTransitionGroupDto_;
import io.tesler.source.services.data.WorkflowTransitionGroupService;
import io.tesler.source.services.meta.WorkflowTransitionGroupMetaBuilder;
import java.io.Serializable;
import java.util.Optional;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WorkflowTransitionGroupServiceImpl
extends VersionAwareResponseService<WorkflowTransitionGroupDto, WorkflowTransitionGroup>
implements WorkflowTransitionGroupService {
    protected WorkflowTransitionGroupServiceImpl() {
        super(WorkflowTransitionGroupDto.class, WorkflowTransitionGroup.class, WorkflowTransitionGroup_.workflowStep, WorkflowTransitionGroupMetaBuilder.class);
    }

    protected Specification<WorkflowTransitionGroup> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> {
            Long parentId = this.getParentId(bc);
            return parentId == null ? cb.and(new Predicate[0]) : cb.equal((Expression)root.get(WorkflowTransitionGroup_.workflowStep).get(BaseEntity_.id), (Object)parentId);
        };
    }

    private Long getParentId(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionGroupPopup.isBc((BcIdentifier)bc)) {
            return Optional.ofNullable(this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong())).map(WorkflowTransition::getSourceStep).map(BaseEntity::getId).orElse(null);
        }
        return bc.getParentIdAsLong();
    }

    protected CreateResult<WorkflowTransitionGroupDto> doCreateEntity(WorkflowTransitionGroup entity, BusinessComponent bc) {
        WorkflowStep workflowStep = (WorkflowStep)Optional.ofNullable(this.baseDAO.findById(WorkflowStep.class, bc.getParentIdAsLong())).orElseThrow(() -> new BusinessException().addPopup(ErrorMessageSource.errorMessage((String)"error.no_parent_workflow_step")));
        entity.setWorkflowStep(workflowStep);
        this.baseDAO.save((Object)entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected ActionResultDTO<WorkflowTransitionGroupDto> doUpdateEntity(WorkflowTransitionGroup entity, WorkflowTransitionGroupDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.maxShowButtonsInGroup)) {
            entity.setMaxShowButtonsInGroup(dto.getMaxShowButtonsInGroup().intValue());
        }
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.nameButtonYet)) {
            entity.setNameButtonYet(dto.getNameButtonYet());
        }
        if (dto.isFieldChanged(WorkflowTransitionGroupDto_.description)) {
            entity.setDescription(dto.getDescription());
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    public Actions<WorkflowTransitionGroupDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

