/*
 * Decompiled with CFR 0.152.
 */
package io.tesler.source.services.data.impl;

import io.tesler.WorkflowServiceAssociation;
import io.tesler.api.data.dictionary.LOV;
import io.tesler.api.service.PluginAware;
import io.tesler.core.crudma.bc.BcIdentifier;
import io.tesler.core.crudma.bc.BusinessComponent;
import io.tesler.core.crudma.impl.VersionAwareResponseService;
import io.tesler.core.dict.WorkflowDictionaries;
import io.tesler.core.dto.rowmeta.ActionResultDTO;
import io.tesler.core.dto.rowmeta.CreateResult;
import io.tesler.core.service.action.Actions;
import io.tesler.engine.workflow.services.WorkflowDao;
import io.tesler.model.core.entity.BaseEntity;
import io.tesler.model.core.entity.BaseEntity_;
import io.tesler.model.workflow.entity.WorkflowTransition;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup;
import io.tesler.model.workflow.entity.WorkflowTransitionConditionGroup_;
import io.tesler.source.dto.WorkflowTransitionConditionGroupDto;
import io.tesler.source.dto.WorkflowTransitionConditionGroupDto_;
import io.tesler.source.services.data.WorkflowTransitionConditionGroupService;
import io.tesler.source.services.meta.WorkflowTransitionConditionGroupFieldMetaBuilder;
import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
@PluginAware
public class WorkflowTransitionConditionGroupServiceImpl
extends VersionAwareResponseService<WorkflowTransitionConditionGroupDto, WorkflowTransitionConditionGroup>
implements WorkflowTransitionConditionGroupService {
    @Autowired
    private WorkflowDao workflowDao;

    protected WorkflowTransitionConditionGroupServiceImpl() {
        super(WorkflowTransitionConditionGroupDto.class, WorkflowTransitionConditionGroup.class, WorkflowTransitionConditionGroup_.transition, WorkflowTransitionConditionGroupFieldMetaBuilder.class);
    }

    protected Specification<WorkflowTransitionConditionGroup> getParentSpecification(BusinessComponent bc) {
        return (Specification & Serializable)(root, cq, cb) -> cb.and((Expression)cb.equal((Expression)root.get(this.parentSpec).get(BaseEntity_.id), (Object)bc.getParentIdAsLong()), (Expression)cb.equal((Expression)root.get(WorkflowTransitionConditionGroup_.condGroupCd), (Object)this.getCondGroupCd(bc)));
    }

    private LOV getCondGroupCd(BusinessComponent bc) {
        if (WorkflowServiceAssociation.wfTransitionCondGroup.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.CONDITION;
        }
        if (WorkflowServiceAssociation.wfPostFuncGroup.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.POST_FUNCTION;
        }
        if (WorkflowServiceAssociation.wfTranCondGroupValid.isBc((BcIdentifier)bc)) {
            return WorkflowDictionaries.ConditionGroupType.VALIDATION;
        }
        return null;
    }

    protected CreateResult<WorkflowTransitionConditionGroupDto> doCreateEntity(WorkflowTransitionConditionGroup entity, BusinessComponent bc) {
        entity.setCondGroupCd(this.getCondGroupCd(bc));
        entity.setTransition((WorkflowTransition)this.baseDAO.findById(WorkflowTransition.class, bc.getParentIdAsLong()));
        this.baseDAO.save((Object)entity);
        this.workflowDao.createDefaultPostFunctions(entity);
        return new CreateResult(this.entityToDto(bc, (BaseEntity)entity));
    }

    protected ActionResultDTO<WorkflowTransitionConditionGroupDto> doUpdateEntity(WorkflowTransitionConditionGroup entity, WorkflowTransitionConditionGroupDto dto, BusinessComponent bc) {
        if (dto.isFieldChanged(WorkflowTransitionConditionGroupDto_.seq)) {
            entity.setSeq(dto.getSeq());
        }
        if (dto.isFieldChanged(WorkflowTransitionConditionGroupDto_.name)) {
            entity.setName(dto.getName());
        }
        return new ActionResultDTO(this.entityToDto(bc, (BaseEntity)entity));
    }

    public ActionResultDTO<WorkflowTransitionConditionGroupDto> deleteEntity(BusinessComponent bc) {
        this.workflowDao.deleteTransitionConditionGroup((WorkflowTransitionConditionGroup)this.isExist(bc.getIdAsLong()));
        return new ActionResultDTO();
    }

    public Actions<WorkflowTransitionConditionGroupDto> getActions() {
        return Actions.builder().create().add().save().add().delete().add().build();
    }
}

